<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeePensionNomineesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employee_pension_nominees', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_id')->nullable();
            $table->foreign('employee_id')->references('id')->on('employees')->onDelete('cascade');
            $table->text("nid_or_birth_certificate")->nullable();
            $table->date("birth_date")->nullable();
            $table->text("relation")->nullable();
            $table->text("name")->nullable();
            $table->tinyInteger("marital_status")->nullable();
            $table->text("disability")->nullable();
            $table->double("designated_part_percent")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_pension_nominees');
    }
}
