<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeFamilyInfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employee_family_infos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_id')->nullable();
            $table->foreign('employee_id')->references('id')->on('employees')->onDelete('cascade');
            $table->text("nid")->nullable();
            $table->tinyInteger("typeofidentification")->nullable();
            $table->tinyInteger("husbandwife")->default(0);
            $table->tinyInteger("child")->default(0);
            $table->text("relation")->nullable();
            $table->date("birthday")->nullable();
            $table->text("name_bangla")->nullable();
            $table->text("name_eng")->nullable();
            $table->tinyInteger("gander")->nullable();
            $table->tinyInteger("autistic")->default(0);
            $table->text("extra")->nullable();
            $table->text("occupation")->nullable();
            $table->text("designation")->nullable();
            $table->text("home_district")->nullable();
            $table->text("organisation")->nullable();
            $table->text("location")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_family_infos');
    }
}
