{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Entry-->
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class=" container ">
            <!--begin::Card-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-3">
                    <div class="card-title">
                        <h3 class="card-label">
                            User Group
                        </h3>
                    </div>
                </div>
                <div class="card-body">
                    <!--begin: Datatable-->
                    <table class="table table-bordered table-checkable text-center" id="kt_datatable_user_group">
                        <thead>
                        <tr>
                            <th>Group</th>
                            @foreach($user_groups as $user_group)
                                <th>{{$user_group->name}}</th>
                            @endforeach

                        </tr>
                        </thead>

                        <tbody>
                        @if(isset($permission_lists) && count($permission_lists) > 0)
                            @foreach($permission_lists as $permission_list)
                                <tr>
                                    <th>{{$permission_list->name}}</th>
                                    @foreach($permission_list->user_group_permission as $user_group_permission)
                                        <th>@if($user_group_permission->permission == 1)<i class="fa fa-check text-success"></i> @else <i class="fas fa-ban text-danger"></i> @endif</th>
                                    @endforeach
                                </tr>
                            @endforeach
                        @endif
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>Action</th>
                                @if(isset($permission_lists) && count($permission_lists) > 0)
                                    @foreach($permission_list->user_group_permission as $user_group_permission)
                                        <th>@if($user_group_permission->user_group_id > 1)<a href="{{route('user_access.edit',['id'=>$user_group_permission->user_group_id])}}"> <i class="fa fa-edit text-primary"></i></a>@endif</th>
                                    @endforeach
                                @endif
                            </tr>
                        </tfoot>

                    </table>
                    <!--end: Datatable-->
                </div>
            </div>

        </div>
        <!--end::Container-->
    </div>
    <!--end::Entry-->
@endsection

{{-- Scripts Section --}}
@section('scripts')
    <!--begin::Page Vendors(used by this page)-->
    <script src="{{asset('plugins/custom/datatables/datatables.bundle.js')}}"></script>
    <!--end::Page Vendors-->

    <!--begin::Page Scripts(used by this page)-->
    {{--    <script src="{{asset('js/pages/crud/datatables/data-sources/html.js')}}"></script>--}}
    <script>
        var KTDatatablesDataSourceHtml = function() {

            var initTable1 = function() {
                var table = $('#kt_datatable_user_group');

                // begin first table
                table.DataTable({
                    "lengthMenu": [[50, -1], [50, "All"]],
                    dom: "<'row'<'col-sm-12 col-md-3'l><'col-sm-12 col-md-6'B><'col-sm-12 col-md-3'f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        'colvis',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        {
                            extend: 'pdfHtml5',
                            orientation: 'landscape',
                            pageSize: 'LEGAL'
                        }
                    ],
                    responsive: true,
                });

            };

            return {

                //main function to initiate the module
                init: function() {
                    initTable1();
                },

            };

        }();

        jQuery(document).ready(function() {
            KTDatatablesDataSourceHtml.init();
        });




    </script>
@endsection
