{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Entry-->
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class=" container ">
            <!--begin::Card-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-3">
                    <div class="card-title">
                        <h3 class="card-label">
                            {{$user_group->name}} Permissions
                        </h3>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{route('user_access.add_to_db')}}" method="post">
                        @csrf
                        <input hidden name="others" value="{{$user_group->id}}">
                        <div class="form-group d-flex">
                            <div class="col-md-4 text-right my-auto">User Group Name</div>
                            <div class="col-md-7"><input type="text" class="form-control" name="group_name" value="{{$user_group->name}}" required></div>
                        </div>
                        <div class="form-group d-flex">
                            <div class="col-md-4 text-right my-auto">Permission List</div>
                        </div>
                        @foreach($user_group->user_group_permission_with_list as $permission_list)
                            <div class="form-check d-flex p-3  my-auto">
                                <div class="col-md-4  text-right">{{$permission_list->user_permission_list->name}}</div>
                                <div class="col-md-7"><input name="group[{{$permission_list->user_permission_list_id}}]" type="checkbox" class="form-check-input ml-2" @if($permission_list->permission == 1) checked @endif></div>
                            </div>
                        @endforeach
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </div>

        </div>
        <!--end::Container-->
    </div>
    <!--end::Entry-->
@endsection
