<?php

namespace Aqualink\User_access_control\Controllers;

use App\Http\Controllers\Controller;
use Aqualink\User_access_control\Models\User_group;
use Aqualink\User_access_control\Models\User_group_permission;
use Aqualink\User_access_control\Models\User_permission_list;
use Illuminate\Http\Request;

class UserGroupController extends Controller
{
    public function index(){
        $user_groups = User_group::with('user_group_permission')->orderBy('id','asc')->get();
        $permission_lists = User_permission_list::with('user_group_permission')->get();
        return view('user_access_control::index',compact('user_groups','permission_lists'));
    }
    public function add(){
        $permission_lists = User_permission_list::all();
        return view('user_access_control::add',compact('permission_lists'));
    }
    public function edit($id){
        if($id < 1){
            return redirect()->route('user_access.index')->with('type','danger')->with('message',' Cant change Administrator access');
        }
        $user_group = User_group::with('user_group_permission_with_list')->findOrFail($id);
        return view('user_access_control::edit',compact('user_group'));
    }
    public function add_to_db(Request $request){
        if(isset($request->group_name)){
            if(isset($request->others) && (int)$request->others > 0){
                $user_group = User_group::find((int)$request->others);
            }else{
                $user_group = new User_group();
            }
            $user_group->name = $request->group_name;
            $user_group->save();
        }
        $permission_lists = User_permission_list::all();
        foreach ($permission_lists as $permission_list){
            $ugp = User_group_permission::where('user_group_id',$user_group->id)->where('user_permission_list_id',$permission_list->id)->first();
            if(!isset($ugp->id)){
                $ugp = new User_group_permission();
                $ugp->user_group_id = $user_group->id;
                $ugp->user_permission_list_id = $permission_list->id;
            }
            if(isset($request->group[$permission_list->id])){
                $ugp->permission = 1;
            }else{
                $ugp->permission = 0;
            }
            $ugp->save();
        }
        return redirect()->route('user_access.index')->with('type','success')->with('message',$user_group->name.' updated successfully');
    }
}
