{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Entry-->
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class=" container ">
            <!--begin::Card-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-3">
                    <div class="card-title">
                        <h3 class="card-label">
                           @isset($thana->id){{$thana->name_en}} all @endisset Thana List
                        </h3>

                        <a style="position:absolute;right:0;margin-right:2%;" type="button"  class="btn btn-info " href="{{route('thana.add')}}">Add new Thana</a>
                    </div>
                </div>
                <div class="card-body">
                    <!--begin: Datatable-->
                    <table class="table table-bordered table-checkable text-center" id="kt_datatable_user_group">
                        <thead>
                        <tr>
                            <th>Thana</th>
                            <th>Thana (বাংলা)</th>
                            <th>Zone</th>
                            <th>Action</th>

                        </tr>
                        </thead>

                        <tbody>
                        @foreach($thanas as $department)
                            <tr>
                                <th>{{$department->name_en}}</th>
                                <th>{{$department->name_bn}}</th>
                                <th>{{$department->zone->name_bn}}</th>

                                <th>
                                    <a href="{{route('thana.edit',['id'=>$department->id])}}" class="ml-2 mr-2"> <i class="fa fa-edit text-primary"></i></a>
                                    <a href="{{route('thana.delete',['id'=>$department->id])}}" class="ml-2 mr-2"> <i class="fa fa-trash text-danger"></i></a>
                                </th>
                            </tr>
                        @endforeach
                        </tbody>

                    </table>
                    <!--end: Datatable-->
                </div>
            </div>

        </div>
        <!--end::Container-->
    </div>
    <!--end::Entry-->
@endsection

{{-- Scripts Section --}}
@section('scripts')
    <!--begin::Page Vendors(used by this page)-->
    <script src="{{asset('plugins/custom/datatables/datatables.bundle.js')}}"></script>
    <!--end::Page Vendors-->

    <!--begin::Page Scripts(used by this page)-->
    {{--    <script src="{{asset('js/pages/crud/datatables/data-sources/html.js')}}"></script>--}}
    <script src="{{asset('js/script.js')}}"></script>
    <script>
        var KTDatatablesDataSourceHtml = function() {

            var initTable1 = function() {
                var table = $('#kt_datatable_user_group');

                // begin first table
                table.DataTable({
                    dom: "<'row'<'col-sm-12 col-md-3'l><'col-sm-12 col-md-6'B><'col-sm-12 col-md-3'f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",

                    buttons: [
                        'colvis',
                        'copyHtml5',
                        'excelHtml5',
                        'csvHtml5',
                        {
                            extend: 'pdfHtml5',
                            orientation: 'landscape',
                            pageSize: 'LEGAL'
                        }
                    ],
                    responsive: true,
                });

            };

            return {

                //main function to initiate the module
                init: function() {
                    initTable1();
                },

            };

        }();

        jQuery(document).ready(function() {
            KTDatatablesDataSourceHtml.init();
        });




    </script>
@endsection
