{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Entry-->
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class=" container ">
            <!--begin::Card-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-3">
                    <div class="card-title">
                        <h3 class="card-label">
                            @isset($thanas->id)Edit {{$thanas->name}} @else Add new Thana @endisset
                        </h3>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{route('thana.add_to_db')}}" method="post">
                        @csrf
                        @isset($thanas->id)<input hidden name="others" value="{{$thanas->id}}">@endisset
                        <div class="form-group d-flex">
                            <div class="col-md-4 text-right my-auto">District</div>
                            <div class="col-md-7"><select name="district" class="form-control">
                                <option selected disabled="disabled">Select District</option>
                                @foreach($districts as $company)
                                    <option
                                        @if(isset($thanas->district_id) && ($thanas->district_id == $company->id))
                                        selected
                                        @endif
                                        value="{{$company->id}}">{{$company->name_en}}({{$company->name_bn}})</option>
                                @endforeach
                            </select></div>
                        </div>

                        <div class="form-group d-flex">
                            <div class="col-md-4 text-right my-auto">Zone</div>
                            <div class="col-md-7">
                                <select name="zone" class="form-control">
                                <option selected disabled="disabled">Select Zone</option>
                                @foreach($zones as $zone)
                                    <option
                                        @if(isset($thanas->zone_id) && ($thanas->zone_id == $zone->id))
                                        selected
                                        @endif
                                        value="{{$zone->id}}">{{$zone->name_en}}({{$zone->name_bn}})</option>
                                @endforeach
                            </select></div>
                        </div>


                        <div class="form-group d-flex">
                            <div class="col-md-4 text-right my-auto">Thana Name(Bangla)</div>
                            <div class="col-md-7"><input type="text" class="form-control" name="name_bn" @isset($thanas->id) value="{{$thanas->name_bn}}" @endisset required></div>
                        </div>
                        <div class="form-group d-flex">
                            <div class="col-md-4 text-right my-auto">Thanas Name(English)</div>
                            <div class="col-md-7"><input type="text" class="form-control" name="name_en" @isset($thanas->id) value="{{$thanas->name_en}}" @endisset required></div>
                        </div>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </div>

        </div>
        <!--end::Container-->
    </div>
    <!--end::Entry-->
@endsection
