{{-- Extends layout --}}
@extends('layout.default')
@section('styles')
    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{asset('plugins/custom/datatables/datatables.bundle.css')}}" rel="stylesheet" type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection
{{-- Content --}}
@section('content')
    <!--begin::Entry-->
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class=" container ">
            <!--begin::Card-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap py-3">
                    <div class="card-title">
                        <h3 class="card-label">
                            Add new District
                        </h3>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{route('district.add_to_db')}}" method="post">
                        @csrf
                        @isset($district->id)<input hidden name="others" value="{{$district->id}}">@endisset
                        <div class="form-group d-flex">
                            <div class="col-md-4 text-right my-auto">District Name (English)</div>
                            <div class="col-md-7"><input type="text" class="form-control" name="name_en" @isset($district->id) value="{{$district->name_en}}" @endisset required></div>
                            
                        </div>
                        <div class="form-group d-flex">
                            <div class="col-md-4 text-right my-auto">District Name (Bangla)</div>
                            <div class="col-md-7"><input type="text" class="form-control" name="name_bn" @isset($district->id) value="{{$district->name_bn}}" @endisset required></div>
                        </div>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                </div>
            </div>

        </div>
        <!--end::Container-->
    </div>
    <!--end::Entry-->
@endsection
