<?php

use Aqualink\District\Controllers\ThanaController;
use Aqualink\District\Controllers\DepartmentController;
use Aqualink\District\Controllers\DistrictController;
use Aqualink\District\Controllers\ZoneController;
use Aqualink\District\Controllers\QoutaController;
use Illuminate\Support\Facades\Route;

Route::group(['namespace'=>'Aqualink/District/controllers','middleware' => ['web','auth']], function () {
    Route::group(['prefix' => 'thana', 'as' => 'thana.'], function () {
        Route::get('/', [ThanaController::class, 'index'])->name('index');
        Route::get('/add', [ThanaController::class, 'add'])->name('add');
        Route::get('/edit/{id}', [ThanaController::class, 'edit'])->name('edit');
        Route::post('/add', [ThanaController::class, 'add_to_db'])->name('add_to_db');
        Route::get('/delete/{id}', [ThanaController::class, 'delete'])->name('delete');
    });
    Route::group(['prefix' => 'district', 'as' => 'district.'], function () {
        Route::get('/', [DistrictController::class, 'index'])->name('index');
        Route::get('/add', [DistrictController::class, 'add'])->name('add');
        Route::get('/edit/{id}', [DistrictController::class, 'edit'])->name('edit');
        Route::post('/add', [DistrictController::class, 'add_to_db'])->name('add_to_db');
        Route::get('/delete/{id}', [DistrictController::class, 'delete'])->name('delete');
        Route::get('/{id}/thanas', [DistrictController::class, 'thanas'])->name('thanas');
    });

    Route::group(['prefix' => 'zone', 'as' => 'zone.'], function () {
        Route::get('/', [ZoneController::class, 'index'])->name('index');
        Route::get('/add', [ZoneController::class, 'add'])->name('add');
        Route::get('/edit/{id}', [ZoneController::class, 'edit'])->name('edit');
        Route::post('/add', [ZoneController::class, 'add_to_db'])->name('add_to_db');
        Route::get('/delete/{id}', [ZoneController::class, 'delete'])->name('delete');
        Route::get('/{id}/thanas', [ZoneController::class, 'thanas'])->name('thanas');
    });

    Route::group(['prefix' => 'qouta', 'as' => 'qouta.'], function () {
        Route::get('/', [QoutaController::class, 'index'])->name('index');
        Route::get('/add', [QoutaController::class, 'add'])->name('add');
        Route::get('/edit/{id}', [QoutaController::class, 'edit'])->name('edit');
        Route::post('/add', [QoutaController::class, 'add_to_db'])->name('add_to_db');
        Route::get('/delete/{id}', [QoutaController::class, 'delete'])->name('delete');
    });
});
