<?php

namespace Aqualink\District\Controllers;

use App\Http\Controllers\Controller;
use Aqualink\District\Models\Zone;
use Aqualink\District\Models\Thana;
use Illuminate\Http\Request;

class ZoneController extends Controller
{
    public function index(){
        $zones = Zone::with('thanas')->get();
        return view('district::zone.index', compact('zones'));
    }
    public function add(){
        return view('district::zone.add');
    }
    public function edit($id){
        $zone = Zone::findOrFail($id);
        // return $district;
        return view('district::zone.add', compact('zone'));
    }
    public function add_to_db(Request $request){
        // return 0;
        if(isset($request->name_en) && isset($request->name_bn)){
            if(isset($request->others) && (int) $request->others > 0){
                $zone = Zone::find((int) $request->others);
            }else{
                $zone = new Zone();
            }
            $zone->name_en = $request->name_en;
            $zone->name_bn = $request->name_bn;
            $zone->save();
        }
        return redirect()->route('zone.index')->with('type', 'success')->with('message', $zone->name_en.' updated successfully');
    }
    public function delete($id){
        $zone = Zone::findOrFail($id);
        $zone->delete();
        return redirect()->route('zone.index')->with('type', 'success')->with('message', $zone->name.' Department Deleted successfully');
    }
    public function thanas($id){  
        $zones = Zone::findOrFail($id);
        $thanas = Thana::where('district_id', $id)->get();
        return view('district::thana.index', compact('zones', 'thanas'));
    }
}
