<?php

namespace Aqualink\District\Controllers;

use App\Http\Controllers\Controller;
use Aqualink\District\Models\District;
use Aqualink\District\Models\Thana;
use Aqualink\District\Models\Zone;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class ThanaController extends Controller
{
    public function index(){
        $districts = District::all();
        $thanas = Thana::with('districts','zone')->get();
        return view('district::thana.index', compact('districts', 'thanas'));
    }
    public function add(){
        $districts = District::all();
        $zones = Zone::all();
        return view('district::thana.add', compact('districts','zones'));
    }
    public function edit($id){
        $districts = District::all();
        $zones = Zone::all();
        $thanas = Thana::findOrFail($id);
        return view('district::thana.add', compact('thanas', 'districts','zones'));
    }
    public function delete($id){
        $Thana = Thana::findOrFail($id);
        $Thana->delete();
        return redirect()->route('thana.index')->with('type', 'success')->with('message', $Thana->name_en.' thana Deleted successfully');
    }
    public function add_to_db(Request $request){
        $request->validate([
            'name_en' => 'required|max:255',
            'name_bn' => 'required|max:255',
        ]);
        if(isset($request->others) && (int) $request->others > 0){
            $thana = Thana::find((int) $request->others);
        }else{
            $thana = new Thana();
            if(isset($request->district)) {
                $thana->district_id = (int) $request->district;
            }
            if(isset($request->zone)) {
                $thana->zone_id = (int) $request->zone;
            }
        }
        $thana->name_bn = $request->name_bn;
        $thana->name_en = $request->name_en;
        $thana->save();
        Cache::forget('Thana');
        $districts = District::all();
        $thanas = Thana::with('districts','zone')->where('district_id',(int)$request->district)->get();
        return view('district::thana.index', compact('districts', 'thanas'))->with('type', 'success')->with('message', $thana->name_en.' updated successfully');
        // return redirect()->route('thana.index')
    }
}
