<?php

namespace Aqualink\District\Controllers;

use App\Http\Controllers\Controller;
use Aqualink\District\Models\Zone;
use Aqualink\District\Models\Thana;
use Aqualink\District\Models\Quota;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class QoutaController extends Controller
{
    public function index(){
        $qoutas = Quota::all();
        return view('district::qouta.index', compact('qoutas'));
    }
    public function add(){
        return view('district::qouta.add');
    }
    public function edit($id){
        $qouta = Quota::findOrFail($id);
        // return $district;
        return view('district::qouta.add', compact('qouta'));
    }
    public function add_to_db(Request $request){
        // return 0;
        if(isset($request->name_en) && isset($request->name_bn)){
            if(isset($request->others) && (int) $request->others > 0){
                $qouta = Quota::find((int) $request->others);
            }else{
                $qouta = new Quota();
            }
            $qouta->name_en = $request->name_en;
            $qouta->name_bn = $request->name_bn;
            $qouta->max_age = $request->max_age;
            $qouta->max_year = $request->max_year;
            $qouta->save();
            Cache::forget('Quota');
        }
        return redirect()->route('qouta.index')->with('type', 'success')->with('message', $qouta->name_en.' updated successfully');
    }
    public function delete($id){
        $qouta = Quota::findOrFail($id);
        $qouta->delete();
        return redirect()->route('qouta.index')->with('type', 'success')->with('message', $qouta->name.' Department Deleted successfully');
    }

}
