<?php

namespace Aqualink\District\Controllers;

use App\Http\Controllers\Controller;
use Aqualink\District\Models\District;
use Aqualink\District\Models\Thana;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class DistrictController extends Controller
{
    public function index(){
        $districts = District::with('thanas')->get();
        return view('district::district.index', compact('districts'));
    }
    public function add(){
        return view('district::district.add');
    }
    public function edit($id){
        $district = District::findOrFail($id);
        // return $district;
        return view('district::district.add', compact('district'));
    }
    public function add_to_db(Request $request){
        // return 0;
        if(isset($request->name_en) && isset($request->name_bn)){
            if(isset($request->others) && (int) $request->others > 0){
                $district = District::find((int) $request->others);
            }else{
                $district = new District();
            }
            $district->name_en = $request->name_en;
            $district->name_bn = $request->name_bn;
            $district->save();
            Cache::forget('District');
        }
        return redirect()->route('district.index')->with('type', 'success')->with('message', $district->name_en.' updated successfully');
    }
    public function delete($id){
        $Department = District::findOrFail($id);
        $Department->delete();
        return redirect()->route('district.index')->with('type', 'success')->with('message', $Department->name.' Department Deleted successfully');
    }
    public function thanas($id){
        $districts = District::findOrFail($id);
        $thanas = Thana::where('district_id', $id)->get();
        return view('district::thana.index', compact('districts', 'thanas'));
    }
}
