<?php

namespace Aqualink\District\Controllers;

use App\Http\Controllers\Controller;
use Aqualink\District\Models\Company;
use Aqualink\District\Models\Department;
use Illuminate\Http\Request;

class DepartmentController extends Controller
{
    public function index(){
        $companys = Company::all();
        $departments = Department::with('company')->get();
        return view('department::department.index', compact('companys', 'departments'));
    }
    public function add(){
        $companys = Company::all();
        return view('department::department.add', compact('companys'));
    }
    public function edit($id){
        $companys = Company::all();
        $department = Department::findOrFail($id);
        return view('department::department.add', compact('department', 'companys'));
    }
    public function delete($id){
        $Department = Department::findOrFail($id);
        $Department->delete();
        return redirect()->route('department.index')->with('type', 'success')->with('message', $Department->name.' Department Deleted successfully');
    }
    public function add_to_db(Request $request){
        $request->validate([
            'name' => 'required|max:255',
        ]);
        if(isset($request->others) && (int) $request->others > 0){
            $department = Department::find((int) $request->others);
        }else{
            $department = new Department();
            if(isset($request->company)) {
                $department->company_id = (int) $request->company;
            }
        }
        $department->name = $request->name;
        $department->save();
        return redirect()->route('department.index')->with('type', 'success')->with('message', $department->name.' updated successfully');
    }
}
