<?php

namespace Aqualink\District\Controllers;

use App\Http\Controllers\Controller;
use Aqualink\Department\Models\Company;
use Aqualink\Department\Models\Department;
use Illuminate\Http\Request;

class CompanyController extends Controller
{
    public function index(){
        $companys = Company::with('department')->get();
        return view('department::company.index', compact('companys'));
    }
    public function add(){
        return view('department::company.add');
    }
    public function edit($id){
        $company = Company::findOrFail($id);
        return view('department::company.add', compact('company'));
    }
    public function add_to_db(Request $request){
        if(isset($request->name)){
            if(isset($request->others) && (int) $request->others > 0){
                $company = Company::find((int) $request->others);
            }else{
                $company = new Company();
            }
            $company->name = $request->name;
            $company->save();
        }
        return redirect()->route('company.index')->with('type', 'success')->with('message', $company->name.' updated successfully');
    }
    public function departments($id){
        $company = Company::findOrFail($id);
        $departments = Department::where('company_id', $id)->get();
        return view('department::department.index', compact('company', 'departments'));
    }
}
