<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

class LeaveType extends Model
{
    use HasFactory;
    public function leavestatus(){
        return $this->hasMany(LeaveStatus::class,'leave_type_id');
    }
    public function myleavestatus(){
        return $this->hasOne(LeaveStatus::class,'leave_type_id')->where('employee_id',Auth::user()->employee_id)
            ->where('date','>=',Carbon::today())->orderBy('date','desc');
    }
    public function myleavestatusApi($id = 1){
        return $this->hasOne(LeaveStatus::class,'leave_type_id')->where('employee_id',$id)
            ->where('date','>=',Carbon::today())->orderBy('date','desc');
    }
}
