<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Employee extends Model
{
    use HasFactory;
    public function employee_personal_info(){
        return $this->hasOne(Employee_personal_info::Class,'employee_id');
    }
    public function employee_family_info(){
        return $this->hasMany(Employee_family_info::Class,'employee_id');
    }
    public function total_child(){
        return $this->hasMany(Employee_family_info::Class,'employee_id')->where('child',1);
    }
    public function employee_normal_child(){
        return $this->hasMany(Employee_family_info::Class,'employee_id')->where('child',1)->where('autistic',0);
    }
    public function employee_autistic_child(){
        return $this->hasMany(Employee_family_info::Class,'employee_id')->where('child',1)->where('autistic',1);
    }
    public function employee_bank_info(){
        return $this->hasOne(Employee_bank_info::Class,'employee_id');
    }
    //...................
    public function employee_present_position(){
        return $this->hasOne(Employee_present_postion::Class,'employee_id');
    }
    public function employee_first_joining(){
        return $this->hasOne(Employee_first_joining::Class,'employee_id');
    }
    public function employee_promotion_higher_scale(){
        return $this->hasMany(Employee_promotion_higher_scale::Class,'employee_id')->orderBy('id');
    }
    public function employee_promotion_higher_scale_workingplace(){
        return $this->hasOne(Employee_promotion_higher_scale::Class,'employee_id')->whereNotNull('working_place')->orderBy('date_of_getting','desc');
    }
    public function employee_transfer(){
        return $this->hasMany(EmployeeTransfer::Class,'employee_id');
    }
    public function employee_transfer_working_place(){
        return $this->hasOne(EmployeeTransfer::Class,'employee_id')->whereNotNull('working_place')->where('start_date','<=',Carbon::today())->where('end_date','>=',Carbon::today())->orderBy('start_date','desc');
    }
    public function employee_accommodation(){
        return $this->hasMany(Employee_accommodation::Class,'employee_id');
    }
    public function rest_and_recreation(){
        return $this->hasMany(EmployeeRestRecreation::Class,'employee_id');
    }
    //------------------
    public function pay_allowance_deduction(){
        return $this->hasMany(Employee_pay_allowance_deduction::Class,'employee_id');
    }
    public function pay_slip(){
        return $this->hasMany(MonthlyPayslip::Class,'employee_id');
    }
    public function pay_slip_plus(){
        return $this->hasMany(MonthlyPayslip::Class,'employee_id')->where('addition',1);
    }
    public function pay_slip_minus(){
        return $this->hasMany(MonthlyPayslip::Class,'employee_id')->where('deduction',1);
    }
    //------------------
    public function employee_gpf(){
        return $this->hasOne(Employee_gpf::Class,'employee_id');
    }
    public function employee_gpf_advance(){
        return $this->hasMany(Employee_gpf_advance::Class,'employee_id');
    }
    public function employee_gpf_nominee(){
        return $this->hasMany(Employee_gpf_nominee::Class,'employee_id');
    }
    //........................
    public function employee_loan(){
        return $this->hasMany(Employee_loan::Class,'employee_id');
    }
    //........................
    public function employee_authorized_leave(){
        return $this->hasMany(Employee_authorized_leave::Class,'employee_id');
    }
    public function employee_leave_lien(){
        return $this->hasMany(Employee_leave_lien::Class,'employee_id');
    }
    //........................
    public function employee_desciplinary_action(){
        return $this->hasMany(Employee_desciplinary_action::Class,'employee_id');
    }
    //........................
    public function employee_pension_nominee(){
        return $this->hasMany(Employee_pension_nominee::Class,'employee_id');
    }
    public function employee_present_address(){
        return $this->hasOne(EmployeeAddress::Class,'employee_id')->where('permanent',0);
    }
    public function employee_present_address_with_zone(){
        return $this->hasOne(EmployeeAddress::Class,'employee_id')->where('permanent',0)->with('thana');
    }
    public function employee_permanent_address(){
        return $this->hasOne(EmployeeAddress::Class,'employee_id')->where('permanent',1);
    }
    public function employee_language(){
        return $this->hasMany(EmployeeLanguage::Class,'employee_id');
    }
    public function employeequalification(){
        return $this->hasMany(EmployeeQualification::Class,'employee_id');
    }
    public function employee_local_training(){
        return $this->hasMany(EmployeeTrainings::Class,'employee_id')->where('is_foreign',0);
    }
    public function employee_foreign_training(){
        return $this->hasMany(EmployeeTrainings::Class,'employee_id')->where('is_foreign',1);
    }
    public function employee_travel(){
        return $this->hasMany(EmployeeTravels::Class,'employee_id');
    }
    public function employee_posingabroad(){
        return $this->hasMany(EmployeePosingabroad::Class,'employee_id');
    }
    public function employee_professionalqualification(){
        return $this->hasMany(EmployeeProfessionalQualification::Class,'employee_id');
    }
    public function employee_publication(){
        return $this->hasMany(EmployeePublication::Class,'employee_id');
    }
    public function employee_hounourrewards(){
        return $this->hasMany(EmployeeHounourRewards::Class,'employee_id');
    }
    public function employee_otherservice(){
        return $this->hasMany(EmployeeOtherservice::Class,'employee_id');
    }
    public function employee_service(){
        return $this->hasOne(EmployeeService::Class,'employee_id');
    }
    public function user()
    {
        return $this->hasOne(User::class, 'employee_id');
    }
    public function record_changelog()
    {
        return $this->morphMany(EmployeeRecordChangeLog::class, 'changeable');
    }

   

}
