<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RestandRecreationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'from_date' => 'required|date_format:d-m-Y',
            'to_date' => 'required|date_format:d-m-Y|after_or_equal:from_date',
            'sanction_number' => 'required',
            'sanction_date' => 'required|date_format:d-m-Y',
        ];
        return $rules;
    }
}
