<?php

namespace App\Http\Middleware;

use Aqualink\User_access_control\Models\User_access;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;

class OnlyadministratorMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $userrole = Cache::remember('User_access', 3600, function() { return User_access::with('user_group')->where('user_id',Auth::id())->where('active',1)->first(); });
        if(!isset(Auth::user()->employee_id) && isset($userrole->id)){
                return $next($request);
        }
        return redirect('/')
            ->with('type','warning')->with('message','Access restricted');
    }
}
