<?php

namespace App\Http\Middleware;

use Aqualink\User_access_control\Models\User_access;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class Employeeinfomodify
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if(isset(Auth::user()->employee_id)){
            if(isset(Auth::user()->email_verified_at) && isset(Auth::user()->mobile_verified_at)){
                return $next($request);
            }else{
               return redirect()->route('manage_employee.edit',['id'=>Auth::user()->employee_id])->with('type','warning')->with('message','You must verify email and contact number');
            }
        }else{
            $userrole = User_access::with('user_group')->where('user_id',Auth::id())->first();
            if(isset($userrole->user_group->user_group_permission_with_list)){
                foreach ($userrole->user_group->user_group_permission_with_list as $list){
                    if($list->user_permission_list->slag == 'employee_info_modification' && $list->permission == 1){
                        return $next($request);
                    }
                }

            }
            return redirect()->back()
                ->with('message',' You are not authorized to this module')
                ->with('type','danger');
        }
    }
}
