<?php

namespace App\Http\Middleware;

use App\Models\Employee;
use Aqualink\User_access_control\Models\User_access;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;

class Employee_personal_info_middleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $userrole = Cache::remember('User_access', 3600, function() { return User_access::with('user_group')->where('user_id',Auth::id())->where('active',1)->first(); });
        if(isset($userrole->user_group->user_group_permission_with_list)){
            foreach ($userrole->user_group->user_group_permission_with_list as $list){
                if($list->user_permission_list->slag == 'employee_personal_info' && $list->permission == 1){
                    return $next($request);
                }
            }
        }
        if(isset(Auth::user()->employee_id) && (int)Auth::user()->employee_id > 0){return $next($request);}
        return redirect()->back()
            ->with('message',' You are not authorized')
            ->with('type','danger');
    }
}
