<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class Employee_leaveMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if(isset(Auth::user()->employee_id)){
            if(isset(Auth::user()->email_verified_at) && isset(Auth::user()->mobile_verified_at)){
                return $next($request);
            }else{
                return redirect()->route('manage_employee.edit',['id'=>Auth::user()->employee_id])->with('type','warning')->with('message','You must verify email and contact number');
            }
        }
        return redirect()->back()
            ->with('type','warning')->with('message','You must verify email and contact number');
    }
}
