<?php

namespace App\Http;

use App\Http\Middleware\Employee_disciplinary_action_middleware;
use App\Http\Middleware\Employee_Family_info_middleware;
use App\Http\Middleware\Employee_GPF_middleware;
use App\Http\Middleware\Employee_leave_lien_middleware;
use App\Http\Middleware\Employee_leaveMiddleware;
use App\Http\Middleware\Employee_loan_middleware;
use App\Http\Middleware\Employee_new_leave_typeMiddleware;
use App\Http\Middleware\Employee_payslip_middleware;
use App\Http\Middleware\Employee_pension_middleware;
use App\Http\Middleware\Employee_personal_info_middleware;
use App\Http\Middleware\Employee_reportMiddleware;
use App\Http\Middleware\Employee_rest_recreation_middleware;
use App\Http\Middleware\Employee_Service_info_middleware;
use App\Http\Middleware\EmployeeDeleteMiddleware;
use App\Http\Middleware\EmployeeinfomodifyMiddleware;
use App\Http\Middleware\GroupManagementMiddleware;
use App\Http\Middleware\Manage_leaveMiddleware;
use App\Http\Middleware\OnlyadministratorMiddleware;
use App\Http\Middleware\UserManagementMiddleware;
use Illuminate\Foundation\Http\Kernel as HttpKernel;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array
     */
    protected $middleware = [
        // \App\Http\Middleware\TrustHosts::class,
        \App\Http\Middleware\TrustProxies::class,
        \Fruitcake\Cors\HandleCors::class,
        \App\Http\Middleware\PreventRequestsDuringMaintenance::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array
     */
    protected $middlewareGroups = [
        'web' => [
            \App\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            \Laravel\Jetstream\Http\Middleware\AuthenticateSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
        ],

        'api' => [
            'throttle:api',
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
        ],
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array
     */
    protected $routeMiddleware = [
        'auth' => \App\Http\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'cache.headers' => \Illuminate\Http\Middleware\SetCacheHeaders::class,
        'can' => \Illuminate\Auth\Middleware\Authorize::class,
        'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
        'password.confirm' => \Illuminate\Auth\Middleware\RequirePassword::class,
        'signed' => \Illuminate\Routing\Middleware\ValidateSignature::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
        'employee_info_modification' => EmployeeinfomodifyMiddleware::class,
        'employee_report' => Employee_reportMiddleware::class,
        'leave_new' => Employee_new_leave_typeMiddleware::class,
        'leave_applications' => Manage_leaveMiddleware::class,
        'employee_leave' => Employee_leaveMiddleware::class,
        'onlyadmin' => OnlyadministratorMiddleware::class,
        'user_group' => GroupManagementMiddleware::class,
        'user_management' => UserManagementMiddleware::class,
        'delete_employee' => EmployeeDeleteMiddleware::class,

        'employee_personal_info' => Employee_personal_info_middleware::class,
        'employee_family_info' => Employee_Family_info_middleware::class,
        'employee_service_info' => Employee_Service_info_middleware::class,
        'employee_gpf' => Employee_GPF_middleware::class,
        'employee_loan' => Employee_loan_middleware::class,
        'employee_leave_lien' => Employee_leave_lien_middleware::class,
        'employee_disciplinary_action' => Employee_disciplinary_action_middleware::class,
        'employee_pension' => Employee_pension_middleware::class,
        'employee_rest' => Employee_rest_recreation_middleware::class,
        'employee_pay_slip' => Employee_payslip_middleware::class,
    ];
}
