<?php

namespace App\Http\Controllers;

use App\Models\LeaveApplication;
use App\Models\LeaveStatus;
use App\Models\LeaveType;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserLeaveManagementController extends Controller
{
    public function leave_lists(){
        $leave_type_lists = LeaveType::with('myleavestatus')->get();
        return view('admin.leave.regular.leave_type_list' , compact('leave_type_lists'));
    }
    public function leave_applications(){
        $leave_lists = LeaveApplication::where('employee_id',Auth::user()->employee_id)->with('leavetype')->orderBy('id','desc')->get();
        return view('admin.leave.regular.leave_application' , compact('leave_lists'));
    }
    public function apply_leave(){
        $leave_list = LeaveType::all();
        return view('admin.leave.regular.create_leave_request' , compact('leave_list'));
    }
    public function get_remaining_balance(Request $request){
        $leave = LeaveType::find($request->id);
        $remainingleave = LeaveStatus::where("employee_id",Auth::user()->employee_id)->where("leave_type_id",$leave->id)->where("date",">=",Carbon::now())->first();
        if(isset($remainingleave->total)){
            $remaining = $remainingleave->total - $remainingleave->used;
        }else{
            $remaining = $leave->balance;
        }
        $data = [
            'remaining' => $remaining,
            'sd' => $leave->minimum_days,
            'carryforward' => $leave->carry_forward,
        ];
        return $data;
    }
    public function post_apply_leave(Request $request){

        $days = date_diff(date_create($request->begin_date), date_create($request->end_date))->d+1;
        if($request->day_status == 2){
            $days = $days/2;
        }

        $total_leaves = LeaveApplication::where('employee_id', Auth::user()->employee_id)
            ->where('approval_status', '=', 1)
            ->whereRaw('DATE(created_at) = YEAR(CURDATE())')
            ->sum('days');
        $leave_type = LeaveType::find($request->leave_id);

        if($leave_type->exceed_maximum_limit == 0 && ($leave_type->balance - $total_leaves) < $days){
            return redirect()->back()->with('message', 'You do not have sufficient balance for this leave!');
        }

        $fileNames = null;

        if($request->has('supporting_document')){
            request()->validate([

                'supporting_document.*' => 'required|mimes:jpeg,png,jpg,pdf,docx,doc|max:3000',

            ]);
            $filepath = 'upload/leave_documents';
            foreach ($request->file('supporting_document') as $supporting_document){
                $fileName = Auth::id().'_'.Auth::user()->name.'_'.time().'.'.$supporting_document->getClientOriginalExtension();

                $supporting_document->move(public_path($filepath), $fileName);
                $fileNames = $fileNames.$filepath.'/'.$fileName.',';
            }

        }
        if(isset($request->other)){
            $leave_request = LeaveApplication::find($request->other);
            $leave_request->employee_id = Auth::user()->employee_id;
            $leave_request->leave_id = $request->leave_id;
            $leave_request->day_status = $request->day_status;
            $leave_request->begin_date = $request->begin_date;
            $leave_request->end_date = $request->end_date;
            $leave_request->days = $days;
            if($fileNames != null){
                $leave_request->attachment = $fileNames;
            }
            $leave_request->additional_info = $request->additional_info;
            $leave_request->save();
//            foreach ($sendnotification as $notification){
//                foreach ($notification->userrole as $userrole){
//                    $notif = new Notification();
//                    $notif->user_id = $userrole->user_id;
//                    $notif->text = Auth::user()->name.' updated one leave request.';
//                    $notif->seen = 0;
//                    $notif->save();
//                }
//            }
        } else {
            $leave_request = new LeaveApplication;
            $leave_request->employee_id = Auth::user()->employee_id;
            $leave_request->leave_id = $request->leave_id;
            $leave_request->day_status = $request->day_status;
            $leave_request->begin_date = $request->begin_date;
            $leave_request->end_date = $request->end_date;
            $leave_request->days = $days;
            $leave_request->attachment = $fileNames;
            $leave_request->additional_info = $request->additional_info;
            $leave_request->save();

//            foreach ($sendnotification as $notification){
//                foreach ($notification->userrole as $userrole){
//                    $notif = new Notification();
//                    $notif->user_id = $userrole->user_id;
//                    $notif->text = Auth::user()->name.' updated one leave request.';
//                    $notif->seen = 0;
//                    $notif->save();
//                }
//            }
        }
        return redirect()->route('myleave.index')->with('type','success')->with('message', 'Leave Request Created!');
    }

    public function edit_leave($id){

        $leave_list = LeaveType::all();
        $application = LeaveApplication::with('leavetype')->find($id);
        $total_leaves = LeaveApplication::where('employee_id', Auth::user()->employee_id)
            ->where('approval_status', 1)
            ->where('leave_id', $application->id)
            ->where('created_at','>=',date("Y-m-d", strtotime('first day of January '.date('Y') )))
            ->where('created_at','<=',date("Y-m-d", strtotime('last day of december '.date('Y') )))
            ->get('id');
        $remaining = $application->leavetype->balance - count($total_leaves);
        $image = explode(',',$application->attachment);
        return view('admin.leave.regular.create_leave_request' , compact('leave_list','application','remaining','image'));

    }
    public function delete_leave($id){

        $application = LeaveApplication::find($id);

        if(isset($application->id) && ($application->approval_status == 0)){
            $application->delete();
            return redirect()->back()->with('type','success')->with('message','Leave request deleted successfully.');
        } else {
            return redirect()->back()->with('type','danger')->with('message','Sorry your leave status changed.');
        }

    }
}
