<?php

namespace App\Http\Controllers;

use App\Models\User;
use Aqualink\User_access_control\Models\User_access;
use Aqualink\User_access_control\Models\User_group;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public function index(){
        $users = User::with('useraccess')->where('employee_id',null)
            ->where('id','>',1)->get();
        return view('admin.user.index',compact('users'));
    }
    public function add(){
        $usergroups = User_group::all();
        return view('admin.user.add',compact('usergroups'));
    }
    public function edit($id){
        $user = User::with('useraccess')->find($id);
        $usergroups = User_group::all();
        return view('admin.user.add',compact('usergroups','user'));
    }
    public function delete($id){
        $user = User::with('useraccess')->find($id);
        $user->delete();
        return redirect()->route('manage_user.index')->with('type','success')->with('message','User deleted successfully');
    }
    public function addtodb(Request $request){
        if(!isset($request->other)){
            $validatedData = $request->validate([
                'email' => ['required','unique:users'],
            ]);
        }
        $validatedData = $request->validate([
            'name' => ['required','string'],
            'rank' => ['required','string'],
            'contact' => ['required','numeric'],
            'user_group' => ['required','numeric'],
            'active_status' => ['required','numeric'],
        ]);
        $usergroups = User_group::findorfail($request->user_group);
        if(isset($request->other)){
            $user = User::find($request->other);
        }else{
            $user = new User();
        }
        $user->name = $request->name;
        $user->rank = $request->rank;
        $user->contact = $request->contact;
        $user->email = $request->email;
        if(isset($request->password)){$user->password = Hash::make($request->password);}
        $user->save();


        $useraccess = User_access::where('user_id',$user->id)->first();
        if(!isset($useraccess->id)){
            $useraccess = new User_access();
            $useraccess->user_id = $user->id;
        }
        $useraccess->active = (int)$request->active_status;
        $useraccess->user_group_id = $usergroups->id;
        $useraccess->save();

        return redirect()->route('manage_user.index')->with('type','success')->with('message','User Created/updated successfully');
    }
}
