<?php

namespace App\Http\Controllers;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use SoapClient;

class SMSverificationController extends Controller
{
    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }

    public function number_send_sms(){
        $randd =  rand(100000,9999999);
        $expiretime = Carbon::now()->modify('+5 min')->format('Y-m-d G:i:s');
        $user = User::with('employee')->find(Auth::id());
        if(isset($user->employee_id) && !isset($user->mobile_verified_at)){
            if(!isset($user->expire) || Carbon::parse($user->expire) < Carbon::now()){
                $user->verification_code = $randd;
                $user->expire = $expiretime;
                $user->save();
//                try{
//                    $soapClient = new SoapClient("https://api2.onnorokomSMS.com/sendSMS.asmx?wsdl");
//                    $paramArray = array(
//                        'userName' => "01683063391",
//                        'userPassword' => "Aqualink@321",
//                        'mobileNumber' => $user->employee->sms_number,
//                        'smsText' => "Land Port Authority PIMS verification code : ".$randd,
//                        'type' => "TEXT",
//                        'maskName' => '',
//                        'campaignName' => '',
//                    );
//                    $value = $soapClient->__call("OneToOne", array($paramArray));
//                    dd($value->OneToOneResult);
//                } catch (\Exception $e) {
//                    dd($e->getMessage());
//                }
                $number=$user->employee->sms_number;
                $text= "Land Port Authority PIMS verification code : ".$randd." will expire at ".$expiretime;
                $this->function->sendsms($number,$text);
            }


        }
        return redirect('/')->with('type','success')->with('message','A verification sms sent to your mobile. Code will expire at '.$expiretime);
    }
    public function number_verify(Request $request){
        if(isset($request->smsverify)){
            $user = User::find(Auth::id());
            if((Carbon::parse($user->expire) >= Carbon::now()) && ($user->verification_code == $request->smsverify)){
                $user->mobile_verified_at = Carbon::now()->format('Y-m-d G:i:s');
                $user->save();

                return redirect()->back()->with('type','success')->with('message','Mobile number verified.');
            }
            return redirect()->back()->with('type','danger')->with('message','Failed !. please try again');
        }
        return redirect()->back();
    }
}
