<?php

namespace App\Http\Controllers;

use App\Models\Employee;
use App\Models\Employee_accommodation;
use App\Models\Employee_authorized_leave;
use App\Models\Employee_desciplinary_action;
use App\Models\Employee_family_info;
use App\Models\Employee_first_joining;
use App\Models\Employee_gpf_advance;
use App\Models\Employee_leave_lien;
use App\Models\Employee_loan;
use App\Models\Employee_personal_info;
use App\Models\Employee_present_postion;
use App\Models\Employee_promotion_higher_scale;
use App\Models\EmployeeAddress;
use App\Models\EmployeeHounourRewards;
use App\Models\EmployeeLanguage;
use App\Models\EmployeeOtherservice;
use App\Models\EmployeePosingabroad;
use App\Models\EmployeeProfessionalQualification;
use App\Models\EmployeePublication;
use App\Models\EmployeeQualification;
use App\Models\EmployeeRestRecreation;
use App\Models\EmployeeService;
use App\Models\EmployeeTrainings;
use App\Models\EmployeeTransfer;
use App\Models\EmployeeTravels;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;

class ReportController extends Controller
{
    private  $function;
    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }
    public function compareByTimeStamp($time1, $time2)
    {
        if (Carbon::parse($time1) < Carbon::parse($time2))
            return 1;
        else if (Carbon::parse($time1) > Carbon::parse($time2))
            return -1;
        else
            return 0;
    }

    public function dashboard(){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){
            if(!isset($loggedin->email_verified_at)){
                $message = (Carbon::parse($loggedin->created_at)->diffInMinutes(Carbon::now()) < 55 ) ? 'A verification email sent to your email. please verify' : 'You must verify your email address';
            }
            if(!isset($loggedin->mobile_verified_at )){
                $message = 'You must verify Mobile Number';
            }
            if(!isset($loggedin->email_verified_at) || !isset($loggedin->mobile_verified_at) ) {
                return redirect()->route('manage_employee.edit', ['id' => $loggedin->employee_id])->with('type', 'info')->with('message', $message);
            }else {
                return redirect()->route('manage_employee.edit', ['id' => $loggedin->employee_id]);
            }
        }

        $employees= Cache::remember('d_e', 120*60, function() { return Employee::whereNotNull('rank')->get(['id','rank']);});
        $personalinfo = Cache::remember('d_E_p_i', 120*60, function() {return Employee_personal_info::whereNotNull('gender')->whereNotNull('region')->whereNotNull('marital_status')->select('gender','region','marital_status')->get();});
        $monthpast = Cache::remember('d_time', 120*60, function() {
            $month = [];
            for($i=-12;$i<=2;$i++){
                if($i >= 0){$i = '+'.$i;}
                array_push($month,now()->modify($i.' month')->format('F Y'));
            }
            return $month;
        });
        $monthfuture = Cache::remember('d_time', 120*60, function() {
            $month = [];
            for($i=-3;$i<=11;$i++){
                if($i >= 0){$i = '+'.$i;}
                array_push($month,now()->modify($i.' month')->format('F Y'));
            }
            return $month;
        });
        $promotions = Cache::remember('d_E_p_h_s', 120*60, function() {
            $p =  Employee_promotion_higher_scale::where('type',1)->whereBetween('date_of_getting',[now()->modify('-1 year'),now()->modify('+2 month')])->get('id','date_of_getting');
            $promotion = [];
            foreach($p as $date){
                $key = \Carbon\Carbon::parse($date->date_of_getting)->format('F Y');
               if(isset($promotion[$key])){ $promotion[$key] += 1;} else {$promotion[$key] = 1;}
            }
            return $promotion;
        });
        $firstjoins = Cache::remember('d_E_f_j', 120*60, function() {
            $f = Employee_first_joining::whereBetween('time',[now()->modify('-1 year'),now()->modify('+2 month')])->get('id','time');
            $firstjoins = [];
            foreach($f as $date){
                $key = \Carbon\Carbon::parse($date->date_of_getting)->format('F Y');
                if(isset($firstjoins[$key])){ $firstjoins[$key] += 1;} else {$firstjoins[$key] = 1;}
            }
            return $firstjoins;
        });

        $transfers = Cache::remember('d_E_f_j', 120*60, function() {
            $t = EmployeeTransfer::whereBetween('sanction_date',[now()->modify('-1 year'),now()->modify('+2 month')])->get('id','time');
            $transfers = [];
            foreach($t as $date){
                $key = \Carbon\Carbon::parse($date->date_of_getting)->format('F Y');
                if(isset($transfers[$key])){ $transfers[$key] += 1;} else {$transfers[$key] = 1;}
            }
            return $transfers;
        });
        $prls = Cache::remember('d_e_prl', 120*60, function() {
            $t = Employee::whereNotNull('prl_date')->whereBetween('prl_date',[now()->modify('-2 month'),now()->modify('+6 month')])->get('id','prl_date');
            $prl = [];
            foreach($t as $date){
                $key = \Carbon\Carbon::parse($date->prl_date)->format('F Y');
                if(isset($prl[$key])){ $prl[$key] += 1;} else {$prl[$key] = 1;}
            }
            return $prl;
        });
        $rest_recreations = Cache::remember('d_e_rest_recreation', 120*60, function() {
            $t = EmployeeRestRecreation::whereBetween('from_date',[now()->modify('-2 month'),now()->modify('+6 month')])->orWhereBetween('to_date',[now()->modify('-2 month'),now()->modify('+6 month')])->get('id','from_date');
            $rest = [];
            foreach($t as $date){
                $key = \Carbon\Carbon::parse($date->from_date)->format('F Y');
                if(isset($rest[$key])){ $rest[$key] += 1;} else {$rest[$key] = 1;}
            }
            return $rest;
        });
        foreach ($monthpast as $month){
            if(!isset($promotions[$month])){$promotions[$month] = 0;}
            if(!isset($firstjoins[$month])){$firstjoins[$month] = 0;}
            if(!isset($transfers[$month])){$transfers[$month] = 0;}
        }
        foreach ($monthfuture as $month){
            if(!isset($prls[$month])){$prls[$month] = 0;}
            if(!isset($rest_recreations[$month])){$rest_recreations[$month] = 0;}
        }
        $employee_on_working_place = Cache::remember('d_e_working_place', 120*60, function() {
            $data = Employee::with(['employee_present_position','employee_promotion_higher_scale_workingplace','employee_transfer_working_place'])->limit(1)->get();
            $workplace = [];
            foreach($data as $employee){
                $wp=[];
                if(isset($employee->employee_present_position->join_date) && isset($employee->employee_present_position->working_place)){
                    $wp[] = ['place'=>(int)$employee->employee_present_position->working_place,'date'=>Carbon::parse($employee->employee_present_position->join_date)->format('Y-m-d')];
                }
                if(isset($employee->employee_promotion_higher_scale_workingplace->date_of_getting) && isset($employee->employee_promotion_higher_scale_workingplace->working_place)){
                    $wp[] = ['place'=>(int)$employee->employee_promotion_higher_scale_workingplace->working_place,'date'=>Carbon::parse($employee->employee_promotion_higher_scale_workingplace->date_of_getting)->format('Y-m-d')];
                }
                if(isset($employee->employee_transfer_working_place->start_date) && isset($employee->employee_transfer_working_place->working_place)){
                    $wp[] = ['place'=>(int)$employee->employee_transfer_working_place->working_place,'date'=>Carbon::parse($employee->employee_transfer_working_place->start_date)->format('Y-m-d')];
                }
                $r = collect($wp)->sortByDesc('date')->first();
                if(!isset($workplace[(int)$r['place']])){$workplace[(int)$r['place']] = 1; }else{
                    $workplace[(int)$r['place']] += 1;
                }
            }
            return $workplace;
        });
        //'employee_promotion_higher_scale','employee_transfer','rest_and_recreation','employee_gpf_advance','employee_loan',''
        $function = $this->function;
        return view('admin.dashboard',compact('employees','function','personalinfo','promotions','firstjoins','transfers','monthpast','monthfuture','prls','rest_recreations','employee_on_working_place'));
    }
   public function present_address(){
       $function = $this->function;
       $datas = EmployeeAddress::with('employee')->where('permanent',0)->get();
       return view('admin.reports.personal.present_address',compact('datas','function'));
   }
    public function permanent_address(){
        $function = $this->function;
        $datas = EmployeeAddress::with('employee')->where('permanent',1)->get();
        return view('admin.reports.personal.permanent_address',compact('datas','function'));
    }
    public function language(){
        $function = $this->function;
        $datas = EmployeeLanguage::with('employee')->get();
        return view('admin.reports.personal.language',compact('datas','function'));
    }
    public function educational_qualification(){
        $function = $this->function;
        $datas = EmployeeQualification::with('employee')->get();
        return view('admin.reports.personal.educational_qualification',compact('datas','function'));
    }
    public function local_training(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-50 year');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow();
        $datas = EmployeeTrainings::with('employee')->where('is_foreign',0)
            ->whereBetween('from',array($startdate,$enddate))
            ->orWhereBetween('to',array($startdate,$enddate))->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.personal.local_training',compact('datas','function','startdate','enddate'));
    }
    public function foreign_training(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-50 year');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow();
        $datas = EmployeeTrainings::with('employee')->where('is_foreign',1)
            ->whereBetween('from',array($startdate,$enddate))
            ->orWhereBetween('to',array($startdate,$enddate))
            ->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.personal.foreign_training',compact('datas','function','startdate','enddate'));
    }
    public function posting_abroad(){
        $function = $this->function;
        $datas = EmployeePosingabroad::with('employee')->get();
        return view('admin.reports.personal.posting_abroad',compact('datas','function'));
    }
    public function professional_qualification(){
        $function = $this->function;
        $datas = EmployeeProfessionalQualification::with('employee')->get();
        return view('admin.reports.personal.professional_qualification',compact('datas','function'));
    }
    public function publication(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-50 year');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow();
        $datas = EmployeePublication::with('employee')
            ->whereBetween('date',array($startdate,$enddate))->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.personal.publication',compact('datas','function','startdate','enddate'));
    }
    public function honours_and_award(){
        $function = $this->function;
        $datas = EmployeeHounourRewards::with('employee')->get();
        return view('admin.reports.personal.honours_and_award',compact('datas','function'));
    }
    public function other_services(){
        $function = $this->function;
        $datas = EmployeeOtherservice::with('employee')->get();
        return view('admin.reports.personal.other_services',compact('datas','function'));
    }
    public function service_history(){
        $function = $this->function;
        $datas = EmployeeService::with('employee')->get();
        return view('admin.reports.personal.service_history',compact('datas','function'));
    }
    public function husband_wife(){
        $function = $this->function;
        $datas = Employee_family_info::with('employee')->where('husbandwife',1)->get();
        return view('admin.reports.husband_wife',compact('datas','function'));
    }
    public function children(){
        $function = $this->function;
        $datas = Employee_family_info::with('employee')->where('child',1)->get();
        return view('admin.reports.children',compact('datas','function'));
    }
    public function present_position(){
        $function = $this->function;
        $datas = Employee_present_postion::with('employee')->get();
        return view('admin.reports.service.present_position',compact('datas','function'));
    }
    public function service_first_join(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-5 year');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow();
        $datas = Employee_first_joining::with('employee')->whereBetween('time',array($startdate,$enddate))->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.service.first_join',compact('datas','function','startdate','enddate'));
    }
    public function service_promotion(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-5 year');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow();
        $datas = Employee_promotion_higher_scale::with('employee')->where('type','1')
            ->whereBetween('date_of_getting',array($startdate,$enddate))->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.service.promotion',compact('datas','function','startdate','enddate'));
    }
    public function service_transfer(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-1 year');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow();
        $datas = EmployeeTransfer::with('employee')
            ->whereBetween('transfer_date',array($startdate,$enddate))->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.service.transfer',compact('datas','function','startdate','enddate'));
    }
    public function service_scale(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-5 year');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow();
        $datas = Employee_promotion_higher_scale::with('employee')->where('type','2')
            ->whereBetween('date_of_getting',array($startdate,$enddate))->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.service.scale',compact('datas','function','startdate','enddate'));
    }
    public function service_accommodation(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-15 year');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow();
        $datas = Employee_accommodation::with('employee')
            ->whereBetween('date_of_getting',array($startdate,$enddate))
            ->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.service.accommodation',compact('datas','function','startdate','enddate'));
    }
    public function gpf_advance(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-15 year');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow();
        $datas = Employee_gpf_advance::with('employee')
            ->whereColumn('sanction_total_no_installment','!=','sanction_no_installment_paid')
            ->whereColumn('sanction_number_interest_installment','!=','sanction_number_interest_installment_paid')
            ->whereBetween('sanction_date',array($startdate,$enddate))
            ->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.gpf_advance',compact('datas','function','startdate','enddate'));
    }
    public function loan(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-15 year');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow();
        $datas = Employee_loan::with('employee')
            ->whereColumn('sanction_total_no_installment','!=','sanction_no_installment_paid')
            ->whereColumn('sanction_number_interest_installment','!=','sanction_number_interest_installment_paid')
            ->whereBetween('sanction_date',array($startdate,$enddate))
            ->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.loan',compact('datas','function','startdate','enddate'));
    }
    public function earned_leave(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-1 year');
        $startdate = $startdate->format('Y-m-d');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow();
        $enddate = $enddate->format('Y-m-d');
        $datas = Employee_authorized_leave::with('employee')
            ->whereBetween('start_date',array($startdate,$enddate))
            ->orWhereBetween('end_date',array($startdate,$enddate));
        if(\request()->input('type') && (int)\request()->input('type') > 0){
            $datas->where('type_of_leave',\request()->input('type'));
            $type = $function->leave_types()[(int)\request()->input('type')][1];
        }else {
            $type = '';
        }
        $datas = $datas->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.earned_leave',compact('datas','function','startdate','enddate','type'));
    }
    public function lien(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-1 year');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow();
        $datas = Employee_leave_lien::with('employee')
            ->whereBetween('start_date',array($startdate,$enddate))
            ->orWhereBetween('end_date',array($startdate,$enddate))
            ->orWhereBetween('sanction_date',array($startdate,$enddate))
            ->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.lien',compact('datas','function','startdate','enddate'));
    }
    public function disciplinary_action(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-1 year');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow();
        $datas = Employee_desciplinary_action::with('employee')
            ->whereBetween('start_date',array($startdate,$enddate));
        if(\request()->input('type') && (int)\request()->input('type') > 0 && isset( $function->disciplinary_action_type_name()[(int)\request()->input('type')])){
            $datas->where('type_of_penalty',\request()->input('type'));
            $type = $function->disciplinary_action_type_name()[(int)\request()->input('type')][2];
        }else {
            $type = '';
        }
        if(\request()->input('nature') && (int)\request()->input('nature') > 0 && isset($function->disciplinary_action_type()[(int)\request()->input('nature')])){
            $datas->where('nature_of_penalty',\request()->input('nature'));
            $nature = $function->disciplinary_action_type()[(int)\request()->input('nature')][1];
        }else {
            $nature = '';
        }
        $datas = $datas->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.disciplinary_action',compact('datas','function','startdate','enddate','type','nature'));
    }
    public function rest_and_recreation(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-1 day');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow()->modify('+3 month');
        $datas = EmployeeRestRecreation::with('employee')
            ->whereBetween('from_date',array($startdate,$enddate))
            ->orWhereBetween('to_date',array($startdate,$enddate))
            ->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.rest_and_recreation',compact('datas','function','startdate','enddate'));
    }
    public function prl(){
        $function = $this->function;
        $startdate = (\request()->input('start_date')) ? Carbon::parse(\request()->input('start_date')) : now()->modify('-1 day');
        $enddate = (\request()->input('end_date')) ? Carbon::parse(\request()->input('end_date')) : Carbon::tomorrow()->modify('+3 month');
        $datas = Employee::whereBetween('prl_date',array($startdate,$enddate))->get();
        $startdate = Carbon::parse($startdate)->format('d F Y');
        $enddate = Carbon::parse($enddate)->format('d F Y');
        return view('admin.reports.prl',compact('datas','function','startdate','enddate'));
    }

    public function all_logs(){
        $loggedin = Auth::user();
        $employee = Employee::with(['record_changelog' => function ($query) {
            $query->orderBy('id','desc');
            $query->with('user');
        }])->get();
        // return $employee;
        return view('admin.employee.infochangelog',compact('employee','loggedin'));
    }
}
