<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Rank;
use Illuminate\Support\Facades\Cache;

class RankController extends Controller
{
    public function index(){
        $ranks = Rank::all();
        return view('admin.rank.index', compact('ranks'));
    }
    public function add(){
        return view('admin.rank.add');
    }
    public function edit($id){
        $rank = Rank::findOrFail($id);
        // return $district;
        return view('admin.rank.add', compact('rank'));
    }
    public function add_to_db(Request $request){
        // return 0;
        if(isset($request->name_en) && isset($request->name_bn)){
            if(isset($request->others) && (int) $request->others > 0){
                $rank = Rank::find((int) $request->others);
            }else{
                $validatedData = $request->validate([
                    'seq_no' => ['required','unique:ranks'],
                ]);
                $rank = new Rank();
            }
            $rank->name_en = $request->name_en;
            $rank->name_bn = $request->name_bn;
            $rank->seq_no = $request->seq_no;
            $rank->save();
            Cache::forget('Rank');
        }
        return redirect()->route('rank.index')->with('type', 'success')->with('message', $rank->name_en.' updated successfully');
    }
    public function delete($id){
        $rank = Rank::findOrFail($id);
        $rank->delete();
        return redirect()->route('rank.index')->with('type', 'success')->with('message', $rank->name_en.' Department Deleted successfully');
    }

}
