<?php

namespace App\Http\Controllers;

use App\Models\Employee;
use App\Models\LeaveApplication;
use App\Models\LeaveStatus;
use App\Models\LeaveType;
use Carbon\Carbon;
use Illuminate\Http\Request;

class LeaveManagementController extends Controller
{
    public function pending_leave_application(){
        $leave_lists = LeaveApplication::with('leavetype','employee')->where("approval_status",0)->get();
        return view('admin.leave.pending_leave_application' , compact('leave_lists'));
    }
    public function leave_application_record(){
        $leave_lists = LeaveApplication::with('leavetype','employee')->where("approval_status",'>',0)->get();
        return view('admin.leave.pending_leave_application' , compact('leave_lists'));
    }

    public function leave_type(){
        $leave_type_lists = LeaveType::all();
        return view('admin.leave.leave_type_list' , compact('leave_type_lists'));
    }

    public function create_leave_type(){
        return view('admin.leave.create_leave_type');

    }
    public function post_create_leave_type(Request $request){
        if(isset($request->others)){
            $leave = LeaveType::find((int)$request->others);
        }
        if(!isset($leave->id)){
            $leave = new LeaveType;
        }
        $leave->name = $request->name;
        $leave->balance = $request->balance;
        $leave->exceed_maximum_limit = ($request->exceed_maximum_limit == null ? 0 : 1) ;
        $leave->carry_forward = ($request->carry_forward == null ? 0 : 1);
        $leave->supporting_documents = ($request->supporting_documnets == null ? 0 : 1);
        $leave->time_period = (int)$request->time_period;
        if((int)$request->time_period == 5 && (int)$request->time_period_day > 5){
            $leave->time_period_day = (int)$request->time_period_day;
        } else{
            $leave->time_period_day = null;
        }
        if(isset($request->supporting_documnets) && $request->supporting_documnets != null){
            $leave->minimum_days = $request->minimum_days;
        }
        $leave->save();

        $users = Employee::all();
        foreach ($users as $user) {
            $this->leavestatusupdate($user->id, $leave->id, 0);
        }


        return redirect()->route('leave.leave_type')->with('message', $leave->name.' Created Successfully ')->with('type','success');

    }
    public function leavestatusupdate($userid,$leaveid,$change){
        $leave = LeaveType::find($leaveid);
        $leavestatus = LeaveStatus::where("employee_id",$userid)->where("leave_type_id",$leave->id)
            ->where("date",">=",Carbon::today())->orderBy("id","desc")->first();
        if(!isset($leavestatus->id)){
            $leavestatus = new LeaveStatus();
            if ($leave->time_period == 1) {
                $leavestatus->date = Carbon::today()->lastOfYear();
            }
            if ($leave->time_period == 2) {
                if (Carbon::today() > Carbon::today()->lastOfYear()->modify("-6 month")) {
                    $leavestatus->date = Carbon::today()->lastOfYear();
                } else {
                    $leavestatus->date = Carbon::today()->lastOfYear()->modify("-6 month");
                }
            }
            if ($leave->time_period == 3) {
                $leavestatus->date = Carbon::today()->lastOfQuarter();
            }
            if ($leave->time_period == 4) {
                $leavestatus->date = Carbon::today()->lastOfMonth();
            }
            if ($leave->time_period == 5) {
                if (isset($leave->time_period_day)) {
                    $leavestatus->date = Carbon::today()->modify("+ " . $leave->time_period_day . " day");
                }
            }
            $leavestatus->employee_id = $userid;
            $leavestatus->leave_type_id = $leave->id;
            $leavestatus->total = $leave->balance;
        }
        if(isset($leavestatus->id)){
            $leavestatus->total = $leavestatus->total + $change;
        }

        $leavestatus->save();
    }

    public function edit_leave_type($id){
        $leavetype = LeaveType::find($id);
        return view('admin.leave.create_leave_type',compact('leavetype'));
    }

    public function view_leave($id){
        $idlist = LeaveApplication::all()->pluck('id')->toArray();

        $leave = LeaveApplication::with('leavetype','employee')->find($id);
        $loc= array_search($leave->id, $idlist);
        if((count($idlist)-1) == $loc){
            $next = $idlist[$loc];
        } else {
            $next = $idlist[$loc+1];
        }

        if($loc != 0){$prev = $idlist[$loc-1];} else {$prev = $idlist[$loc];}
        if(isset($leave->id)){
            $image = explode(',',$leave->attachment);
            return view('admin.leave.leave_request' , compact('leave','image','next','prev'));
        } else {
            redirect()->back()->with('message', 'No new leave request exist')->with('type','danger');
        }
    }
    public function post_view_leave($id, Request $request){
        $idlist = LeaveApplication::all()->pluck('id')->toArray();

        $leave = LeaveApplication::with('leavetype','employee')->find($id);
        $lastleavestatus = $leave->approval_status;
        if(isset($request->ap)){
            $leave->approval_status = $request->ap;
            $leave->save();
            if($lastleavestatus != $request->ap){
                $leavestatus = LeaveStatus::where("employee_id",$leave->employee_id)
                    ->where("leave_type_id",$leave->leave_id)
                    ->where("date",">=",Carbon::now())
                    ->first();

                if(($lastleavestatus == 0 || $lastleavestatus == 1 ) && $request->ap == 2){
                    $leavestatus->used = $leavestatus->used + (double)$leave->days;
                }
                if($lastleavestatus == 2 && $request->ap == 1){
                    $leavestatus->used = $leavestatus->used - (double)$leave->days;
                }
                $leavestatus->save();
            }


//            $sendnotification = UserCategory::with('userrole')->where('leave_management',1)->get();
//            foreach ($sendnotification as $notification){
//                foreach ($notification->userrole as $userrole){
//                    $notif = new Notification();
//                    $notif->user_id = $userrole->user_id;
//                    if( $request->ap == 1) {
//                        $notif->text = $leave->user->name . ' Leave Request Rejected';
//                    }
//                    if( $request->ap == 2) {
//                        $notif->text = $leave->user->name . ' Leave Request Approved';
//                    }
//                    $notif->seen = 0;
//                    $notif->save();
//                }
//            }
//            $notif = new Notification();
//            $notif->user_id = $leave->user_id;
//            if( $request->ap == 1) {
//                $notif->text = 'Your '.$leave->leavetype->name . ' Leave Request Rejected';
//            }
//            if( $request->ap == 2) {
//                $notif->text = 'Your '.$leave->leavetype->name . ' Leave Request Approved';
//            }
//            $notif->seen = 0;
//            $notif->save();
        }
        $loc= array_search($leave->id, $idlist);
        if((count($idlist)-1) == $loc){
            $next = $idlist[$loc];
        } else {
            $next = $idlist[$loc+1];
        }
        if( $request->ap == 1){
            return redirect()->route('leave.view_leave',['id'=>$next])->with('message', 'Previous leave Rejected ')->with('type','danger');
        }
        if( $request->ap == 2){
            return redirect()->route('leave.view_leave',['id'=>$next])->with('message', 'Previous leave Approved ')->with('type','success');
        }
    }


    public function remaining_balance(){
        $allstatus = LeaveStatus::with('leavetype','employee')
//            ->where('date','>=',Carbon::today()->firstOfYear())
//            ->where('date','<=',Carbon::today()->lastOfYear())
            ->get();
        return view('admin.leave.status',compact('allstatus'));
    }
    public function post_leave_request(Request $request){
        $days = date_diff(date_create($request->begin_date), date_create($request->end_date))->d+1;
        if($request->day_status == 2){
            $days = $days/2;
        }
        $total_leaves = LeaveApplication::where('user_id', '=', Auth::id())
            ->where('approval_status', '=', 1)
            ->whereRaw('DATE(created_at) = YEAR(CURDATE())')
            ->sum('days');
        $leave_type = LeaveType::find($request->leave_id);

        if($leave_type->exceed_maximum_limit == 0 && ($leave_type->balance - $total_leaves) < $days){
            return redirect()->back()->with('message', 'You do not have sufficient balance for this leave!');
        }

        $fileNames = null;

        if($request->has('supporting_document')){
            request()->validate([

                'supporting_document.*' => 'required|mimes:jpeg,png,jpg,pdf,docx,doc|max:3000',

            ]);
            foreach ($request->file('supporting_document') as $supporting_document){
                $fileName = Auth::id().'_'.Auth::user()->name.'_'.time().'.'.$supporting_document->getClientOriginalExtension();

                $supporting_document->move(public_path('leave_documents'), $fileName);
                $fileNames = $fileNames.$fileName.',';
            }

        }



        $leave_request = new LeaveApplication;
        $leave_request->employee_id = Auth::id();
        $leave_request->leave_id = $request->leave_id;
        $leave_request->day_status = $request->day_status;
        $leave_request->begin_date = $request->begin_date;
        $leave_request->end_date = $request->end_date;
        $leave_request->days = $days;
        $leave_request->attachment = $fileNames;
        $leave_request->additional_info = $request->additional_info;
        $leave_request->save();


        return redirect()->back()->with('message', 'Leave Request Created!')->with('type','success');


    }


    public function create_leave(){

        $leave_list = LeaveType::paginate(15);

        return view('admin.leave.create_leave' , compact('leave_list'));


    }

    public function edit_leave_list(Request $request){
        $change = 0;
        $leave = LeaveType::find($request->id);
        $leave->name = $request->name;
        if($request->balance != $leave->balance){
            $change = (int)$request->balance - $leave->balance;
        }
        $leave->balance = $request->balance;
        $leave->exceed_maximum_limit = ($request->exceed_maximum_limit == null ? 0 : 1) ;
        $leave->carry_forward = ($request->carry_forward == null ? 0 : 1);
        $leave->supporting_documents = ($request->supporting_documents == null ? 0 : 1);
        $leave->time_period = (int)$request->time_period;
        if((int)$request->time_period == 5 && (int)$request->time_period_day > 5){
            $leave->time_period_day = (int)$request->time_period_day;
        } else{
            $leave->time_period_day = null;
        }
        $leave->user_type = (int)$request->user_type;
        if($request->supporting_documents != null){
            $leave->minimum_days = $request->minimum_days;
        }else{
            $leave->minimum_days = 0;
        }
        $leave->save();

        $users = User::where('remove',  0)->get();
        foreach ($users as $user){
            if($user->id > 1){
                if($leave->user_type == 0) {
                    $this->leavestatusupdate($user->id,$leave->id,$change);
                }elseif ($user->duty_type == 1  && $leave->user_type == 1){
                    $this->leavestatusupdate($user->id,$leave->id,$change);
                }elseif ($user->duty_type == 2  && $leave->user_type == 2){
                    $this->leavestatusupdate($user->id,$leave->id,$change);
                }

            }
        }

        return redirect()->back()->with('message', 'Leave Updated Successfully!');


    }

    public function get_leave_details(Request $request){



        return LeaveType::find($request->id);


    }

    public function get_remaining_balance(Request $request){

        $leave = LeaveType::find($request->id);
        $remainingleave = Leave_status::where("user_id",Auth::id())->where("leave_type_id",$leave->id)->where("date",">=",Carbon::now())->first();
        if(isset($remainingleave->total)){
            $remaining = $remainingleave->total - $remainingleave->used;
        }else{
            $remaining = $leave->balance;
        }
        $data = [
            'remaining' => $remaining,
            'sd' => $leave->minimum_days,
            'carryforward' => $leave->carry_forward,
        ];
        return $data;


    }

    public function leave_application(){


        $leave_lists = LeaveApplication::with('leavetype','user')
            ->where("approval_status",">",0)->get();
        return view('admin.leave.leave_application' , compact('leave_lists'));


    }



    public function ajax_leave_application(Request $request){

        $draw = $request->get('draw');
        $start = $request->get('start');
        $length = $request->get('length');

        $search = $request->get('search')['value'];

        $leaves = DB::table('leave_applications')
            ->join('leave_types', 'leave_applications.leave_id', '=', 'leave_types.id')
            ->select('leave_types.name', 'leave_applications.day_status', DB::raw('DATE_FORMAT(leave_applications.begin_date, "%d %M %Y") as begin_date') , DB::raw('DATE_FORMAT(leave_applications.end_date, "%d %M %Y") as end_date'), 'leave_applications.days', 'leave_applications.additional_info', 'leave_applications.attachment', 'leave_applications.approval_status')
            ->where('leave_applications.user_id', '=', Auth::id());
        if($search != null){
            $leaves = $leaves->where(DB::raw("CONCAT(leave_types.name, ' ', leave_applications.day_status, ' ', DATE_FORMAT(leave_applications.begin_date, '%d %M %Y'), DATE_FORMAT(leave_applications.end_date, '%d %M %Y'), leave_applications.days, ' ', COALESCE(leave_applications.additional_info,''), ' ', (CASE WHEN leave_applications.approval_status = 0 THEN 'Not Approved' WHEN leave_applications.approval_status = 1 THEN 'Approved' ELSE 'Rejected' END) )"), 'LIKE', "%".$search."%");
        }
        $total = $leaves->count();
        $leaves =  $leaves->offset($start)
            ->limit($length)
            ->get();

        $data = array(
            'draw' => $draw,
            'recordsTotal' => $total,
            'recordsFiltered' => $total,
            'data' => $leaves,
        );

        return $data;

    }


}
