<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Language;
use Illuminate\Support\Facades\Cache;

class LanguageController extends Controller
{
    public function index(){
        $languages = Language::all();
        return view('admin.language.index', compact('languages'));
    }
    public function add(){
        return view('admin.language.add');
    }
    public function edit($id){
        $language = Language::findOrFail($id);
        // return $district;
        return view('admin.language.add', compact('language'));
    }
    public function add_to_db(Request $request){
        // return 0;
        if(isset($request->name_en) && isset($request->name_bn)){
            if(isset($request->others) && (int) $request->others > 0){
                $language = Language::find((int) $request->others);
            }else{
                $language = new Language();
            }
            $language->name_en = $request->name_en;
            $language->name_bn = $request->name_bn;
            $language->save();
            Cache::forget('Language');
        }
        return redirect()->route('language.index')->with('type', 'success')->with('message', $language->name_en.' updated successfully');
    }
    public function delete($id){
        $language = Language::findOrFail($id);
        $language->delete();
        return redirect()->route('language.index')->with('type', 'success')->with('message', $language->name_en.' Department Deleted successfully');
    }

}
