<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;
use App\Http\Requests\RestandRecreationRequest;
use App\Models\Employee;
use App\Models\EmployeeRestRecreation;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RestandRecreationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function formoutput($array)
    {
        if(isset($array['id'])){ $array['id'] = (int) $array['id']; }
        $array['from_date'] = Carbon::parse($array['from_date']);
        $array['to_date']  =  Carbon::parse($array['to_date']);
        $array['sanction_number']  = $array['sanction_number'];
        $array['sanction_date'] = Carbon::parse($array['sanction_date']);
        return  $array;
    }
    public function index($id)
    {
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            'rest_and_recreation'
        )->findorfail($id);
        return view('admin.employee.rest_and_recreation',compact('employee','loggedin'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        if((int)\request()->get('did') > 0 ){
            $employee = Employee::findorfail($id);
            $data = EmployeeRestRecreation::where('id',(int)\request()->get('did'))->where('employee_id',$employee->id)->first();
            return view('admin.employee.extra_partial_page.rest_recreation',compact('data','loggedin','employee'));
        }
        if((int)\request()->get('delete_id') > 0 ){
            $data = EmployeeRestRecreation::where('id',(int)\request()->get('delete_id'))->where('employee_id',(int)$id)->delete();
            return 'success';
        }
        return back();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store($id,RestandRecreationRequest $request)
    {
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        if(isset($request->did)){
            $request->validate([
                'did'=>'numeric'
            ]);
            $employeerest = EmployeeRestRecreation::where('id', (int)$request->did)->where('employee_id', (int)$id)->update($this->formoutput($request->validated()));
        }else{
            $employeerest = EmployeeRestRecreation::firstOrCreate(['employee_id'=>(int)$id]+$this->formoutput($request->validated()));
        }
        return back()->with('type','success')->with('message','Created/Updated successfully');

    }
}
