<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;

use App\Http\Controllers\FunctionController;
use App\Models\Employee;
use App\Models\Employee_accommodation;
use App\Models\Employee_first_joining;
use App\Models\Employee_personal_info;
use App\Models\Employee_present_postion;
use App\Models\Employee_promotion_higher_scale;
use App\Models\EmployeeRestRecreation;
use App\Models\EmployeeTransfer;
use Aqualink\District\Models\Quota;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PresentPositionController extends Controller
{
    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }

    public function index($id){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            'employee_present_position',
            'employee_first_joining',
            'employee_accommodation',
            'employee_promotion_higher_scale',
            'employee_transfer'
        )->findorfail($id);
        if(!isset($employee->quota)){return redirect()->route('manage_employee.edit',['id'=>$employee->id]);}
        $function = $this->function;
        return view('admin.employee.information_related_to_service',compact('employee','loggedin','function'));
    }
    public function db($id,Request $request){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
//        dd($request->all());

        $employee = Employee::with(
            'employee_present_position',
            'employee_first_joining',
            'rest_and_recreation'
        )->find($id);
        if(isset($employee->id)) {
            if(isset($request->rank) && (int)$request->rank > 0){
                $employee->rank = (int)$request->rank;
                if(!isset(Auth::user()->employee_id) && $employee->isDirty()){
                    $keys = array_keys($employee->getOriginal());
                    foreach ($keys as $dkey) {
                        $employee->record_changelog()->create([
                            'employee_id' => $employee->id,
                            'user_id' => Auth::id(),
                            'name' => 'Rank Changed',
                            'old' => $employee->getOriginal($dkey),
                            'new' => $employee[$dkey],
                            'record_type' => 2,
                        ]);
                    }
                }

                $employee->save();
            }
            $employee_present_position = $employee->employee_present_position;
            if (isset($employee_present_position->employee_id)) {
                $present_position = Employee_present_postion::find($employee_present_position->id);
            } else {
                $present_position = new Employee_present_postion();
                $present_position->employee_id = $employee->id;
            }
//            if(isset($request->present_position['post'])){$present_position->post = $request->present_position['post'];}
            if(isset($request->present_position['join_date'])){$present_position->join_date = Carbon::parse($request->present_position['join_date']);}
            if(isset($request->present_position['grade'])){$present_position->grade = $request->present_position['grade'];}
            if(isset($request->present_position['grade']) && (int)$request->present_position['grade'] >0){
                $present_position->grade_no = $this->function->present_position_present_grade()[(int)$request->present_position['grade']][6];
            }
            if(isset($request->present_position['scale'])){$present_position->scale = $request->present_position['scale'];}
            if(isset($request->present_position['class'])){$present_position->class = (int)$request->present_position['class'];}
            if(isset($request->present_position['working_place'])){$present_position->working_place = (int)$request->present_position['working_place'];}
            if(!isset(Auth::user()->employee_id) && $present_position->isDirty()){
                $keys = array_keys($present_position->getOriginal());
                foreach ($keys as $dkey) {
                    if ($dkey != 'employee_id' || $dkey != 'created_at' || $dkey != 'updated_at') {
                        $key2 = str_replace('_', ' ', $dkey);
                        if (isset($employee_present_position->employee_id)) {
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'Present Position : '. $key2,
                                'old' => '',
                                'new' => $present_position[$dkey],
                                'record_type' => 1,
                            ]);
                        } elseif ($present_position->isDirty($dkey)) {
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'Present Position : ' . $key2,
                                'old' => $present_position->getOriginal($dkey),
                                'new' => $present_position[$dkey],
                                'record_type' => 2,
                            ]);
                        }
                    }
                }
            }
            $present_position->save();

            $employee_first_joining = $employee->employee_first_joining;
            if (isset($employee_first_joining->employee_id)) {
                $first_join = Employee_first_joining::find($employee_first_joining->id);

            } else {
                $first_join = new Employee_first_joining();
                $first_join->employee_id = $employee->id;
            }
            if(isset($request->first_join['working_place'])){$first_join->working_place  = $request->first_join['working_place'];}
            if(isset($request->first_join['time'])){
                $first_join->time  = Carbon::parse($request->first_join['time']);
            }
            if(isset($request->first_join['grade'])){$first_join->grade  = $request->first_join['grade'];}
            if(isset($request->first_join['scale'])){$first_join->scale  = $request->first_join['scale'];}
            if(isset($request->first_join['old_time'])){
                $first_join->old_time  = Carbon::parse($request->first_join['old_time']);
            }
           if(isset($request->first_join['old_grade'])){
               $first_join->old_grade  = $request->first_join['old_grade'];
           }
           if(isset($request->first_join['old_scale'])){
               $first_join->old_scale  = $request->first_join['old_scale'];
           }
            if(isset($request->first_join['job_permanent_date'])){
                $first_join->job_permanent_date  = Carbon::parse($request->first_join['job_permanent_date']);
            }
            if(isset($request->first_join['job_permanent_rank'])){
                $first_join->job_permanent_rank  = (int)$request->first_join['job_permanent_rank'];
            }
            if(!isset(Auth::user()->employee_id) && $first_join->isDirty()){
                $keys = array_keys($first_join->getOriginal());
                foreach ($keys as $dkey) {
                    if ($dkey != 'employee_id' || $dkey != 'created_at' || $dkey != 'updated_at') {
                        $key2 = str_replace('_', ' ', $dkey);
                        if (isset($employee_present_position->employee_id)) {
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'Service First Join : '. $key2,
                                'old' => '',
                                'new' => $first_join[$dkey],
                                'record_type' => 1,
                            ]);
                        } elseif ($first_join->isDirty($dkey)) {
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'Service First Join : ' . $key2,
                                'old' => $first_join->getOriginal($dkey),
                                'new' => $first_join[$dkey],
                                'record_type' => 2,
                            ]);
                        }
                    }
                }
            }

            $first_join->save();
            if(isset($employee->quota) && isset($first_join->time) && count($employee->rest_and_recreation) < 1){
                $quota = Quota::find((int)$employee->quota);
                if(isset($quota->id)){
                    if(!isset($employee->prl_date) || Carbon::parse($employee->dob)->diffInYears($employee->prl_date) > (int)$quota->max_age){
                        $prl_date = Carbon::parse($employee->dob)->modify('+'.$quota->max_age.' year');
                        $employee->prl_date = $prl_date;
                        $employee->save();
                    }
                }
            }

            if(isset($request->inf_promotion) && count($request->inf_promotion) > 0){
                foreach ($request->inf_promotion as $key=>$inf_promotion){
                    $olddata = Employee_promotion_higher_scale::where('employee_id', $employee->id)->where('type',1)->orderBy('id', 'desc')->first();
                    if (count(explode('x', $key)) > 1 && isset($inf_promotion['rank']) && isset($inf_promotion['dog']) && isset($inf_promotion['pay_grade'])) {
                        $promotion = new Employee_promotion_higher_scale();
                        $promotion->employee_id = $employee->id;
                        if(strftime($inf_promotion['dog']) && isset($olddata->id)){
                            $olddata->end_date = Carbon::parse($inf_promotion['dog'])->modify('-1 day');
                            $olddata->save();
                        }
                        $promotion->type = 1;
                    }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                        $key = (int)$key;
                        $promotion = Employee_promotion_higher_scale::find($key);
                    }
                    if(isset($inf_promotion['rank'])){$promotion->rank = (int)$inf_promotion['rank'];}
                    if(isset($inf_promotion['dog'])){$promotion->date_of_getting = Carbon::parse($inf_promotion['dog']);}
                    if (isset($inf_promotion['end_date'])) {$promotion->end_date = Carbon::parse($inf_promotion['end_date']);}
                    if (isset($inf_promotion['sanction_date'])) {$promotion->sanction_date = Carbon::parse($inf_promotion['sanction_date']);}
                    if(isset($inf_promotion['pay_grade'])){$promotion->pay_grade = $inf_promotion['pay_grade'];}
                    if(isset($inf_promotion['sanction_number'])){$promotion->sanction_number = (int)$inf_promotion['sanction_number'];}
                    if(isset($inf_promotion['memo_name'])){$promotion->memo_name = $inf_promotion['memo_name'];}
                    if (isset($inf_promotion['pay_scale'])) {
                        $promotion->pay_scale = $inf_promotion['pay_scale'];
                    }
                    if (isset($inf_promotion['basic_pay'])) {
                        $promotion->basic_pay = $inf_promotion['basic_pay'];
                    }
                    if (isset($inf_promotion['working_place'])) {
                        $promotion->working_place = (int)$inf_promotion['working_place'];
                    }
                    if (isset($inf_promotion['time_scale'])) {
                        $promotion->time_scale = (int)$inf_promotion['time_scale'];
                    }
                    if(isset($promotion)){
                        if(!isset(Auth::user()->employee_id) && $promotion->isDirty()){
                            $keys = array_keys($promotion->getOriginal());
                            foreach ($keys as $dkey) {
                                $key2 = str_replace('_',' ',$dkey);
                                if($dkey != 'created_at' || $dkey != 'updated_at'){
                                    if (count(explode('x', $key)) > 1) {
                                        if(isset($promotion[$dkey])){
                                            $employee->record_changelog()->create([
                                                'employee_id' => $employee->id,
                                                'user_id' => Auth::id(),
                                                'name' => 'Service Promotion : ' . $key2,
                                                'old' => '',
                                                'new' => $promotion[$dkey],
                                                'record_type' => 1,
                                            ]);
                                        }
                                    } elseif ($promotion->isDirty($dkey)) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'Service Promotion : '.$key2,
                                            'old' => $promotion->getOriginal($dkey),
                                            'new' => $promotion[$dkey],
                                            'record_type' => 2,
                                        ]);
                                    }
                                }
                            }
                        }
                        $promotion->save();
                    }

                }
            }
            if(isset($request->inf_transfer) && count($request->inf_transfer) > 0){
                foreach ($request->inf_transfer as $key=>$inf_transfer){
                    $olddata = EmployeeTransfer::where('employee_id', $employee->id)->orderBy('id', 'desc')->first();
                    if (count(explode('x', $key)) > 1 && isset($inf_transfer['rank']) && isset($inf_transfer['transfer_date']) && isset($inf_transfer['working_place'])) {
                        $transferdata = new EmployeeTransfer();
                        $transferdata->employee_id = $employee->id;
                    }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                        $key = (int)$key;
                        $transferdata = EmployeeTransfer::find($key);
                    }
                    if(isset($inf_transfer['working_place'])){$transferdata->working_place = (int)$inf_transfer['working_place'];}
                    if(isset($inf_transfer['rank'])){$transferdata->rank = (int)$inf_transfer['rank'];}
                    if(isset($inf_transfer['sanction_number'])){$transferdata->sanction_number = (int)$inf_transfer['sanction_number'];}
                    if(isset($inf_transfer['transfer_date'])){$transferdata->transfer_date = Carbon::parse($inf_transfer['transfer_date']);}
                    if (isset($inf_transfer['end_date'])) {$transferdata->end_date = Carbon::parse($inf_transfer['end_date']);}
                    if (isset($inf_transfer['start_date'])) {$transferdata->start_date = Carbon::parse($inf_transfer['start_date']);}
                    if (isset($inf_transfer['memo_no'])) {$transferdata->memo_no = $inf_transfer['memo_no'];}
                    if (isset($inf_transfer['wing_section'])) {$transferdata->wing_section = $inf_transfer['wing_section'];}
                    if(isset($transferdata)){
                        if(!isset(Auth::user()->employee_id) && $transferdata->isDirty()){
                            $keys = array_keys($transferdata->getOriginal());
                            foreach ($keys as $dkey) {
                                $key2 = str_replace('_',' ',$dkey);
                                if($dkey != 'created_at' || $dkey != 'updated_at'){
                                    if (count(explode('x', $key)) > 1) {
                                        if(isset($transferdata[$dkey])){
                                            $employee->record_changelog()->create([
                                                'employee_id' => $employee->id,
                                                'user_id' => Auth::id(),
                                                'name' => 'Service Transfer : ' . $key2,
                                                'old' => '',
                                                'new' => $transferdata[$dkey],
                                                'record_type' => 1,
                                            ]);
                                        }
                                    } elseif ($transferdata->isDirty($dkey)) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'Service Transfer : '.$key2,
                                            'old' => $transferdata->getOriginal($dkey),
                                            'new' => $transferdata[$dkey],
                                            'record_type' => 2,
                                        ]);
                                    }
                                }
                            }
                        }
                        $transferdata->save();
                    }

                }
            }

            if(isset($request->inf_pro_pay) && count($request->inf_pro_pay) > 0){
                foreach ($request->inf_pro_pay as $key=>$inf_promotion){
                    if (count(explode('x', $key)) > 1 && isset($inf_promotion['pay_grade']) && isset($inf_promotion['pay_scale']) && isset($inf_promotion['basic_pay']) && isset($inf_promotion['time_scale'])
                        && isset($inf_promotion['dog'])) {
                        $pro_payscale = new Employee_promotion_higher_scale();
                        $pro_payscale->employee_id = $employee->id;
                        $pro_payscale->type = 2;
                    }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                        $key = (int)$key;
                        $pro_payscale = Employee_promotion_higher_scale::find($key);
                    }
                    if(isset($inf_promotion['dog'])){$pro_payscale->date_of_getting = Carbon::parse($inf_promotion['dog'])->format('Y-m-d');}
                    if(isset($inf_promotion['sanction_date'])){$pro_payscale->sanction_date = Carbon::parse($inf_promotion['sanction_date']);}
                    if (isset($inf_promotion['end_date'])) {$pro_payscale->end_date = Carbon::parse($inf_promotion['end_date']);}
                    if(isset($inf_promotion['pay_grade'])){$pro_payscale->pay_grade = $inf_promotion['pay_grade'];}
                    if(isset($inf_promotion['sanction_number'])){$pro_payscale->memo_no = $inf_promotion['sanction_number'];}
                    if (isset($inf_promotion['pay_scale'])) {
                        $pro_payscale->pay_scale = $inf_promotion['pay_scale'];
                    }
                    if (isset($inf_promotion['basic_pay'])) {
                        $pro_payscale->basic_pay = $inf_promotion['basic_pay'];
                    }
                    if (isset($inf_promotion['time_scale'])) {
                        $pro_payscale->time_scale = (int)$inf_promotion['time_scale'];
                    }
                    if(isset($pro_payscale)){
                        if(!isset(Auth::user()->employee_id) && $pro_payscale->isDirty()){
                            $keys = array_keys($pro_payscale->getOriginal());
                            foreach ($keys as $dkey) {
                                $key2 = str_replace('_',' ',$dkey);
                                if($dkey != 'created_at' || $dkey != 'updated_at'){
                                    if (count(explode('x', $key)) > 1) {
                                        if(isset($pro_payscale[$dkey])){
                                            $employee->record_changelog()->create([
                                                'employee_id' => $employee->id,
                                                'user_id' => Auth::id(),
                                                'name' => 'Service Pay scale Promotion : ' . $key2,
                                                'old' => '',
                                                'new' => $pro_payscale[$dkey],
                                                'record_type' => 1,
                                            ]);
                                        }
                                    } elseif ($pro_payscale->isDirty($dkey)) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'Service Pay scale Promotion : '.$key2,
                                            'old' => $pro_payscale->getOriginal($dkey),
                                            'new' => $pro_payscale[$dkey],
                                            'record_type' => 2,
                                        ]);
                                    }
                                }
                            }
                        }
                        $pro_payscale->save();
                    }

                }
            }
            if(isset($request->inf_accom) && count($request->inf_accom) > 0){
                foreach ($request->inf_accom as $key=>$inf_accom){

                    if (count(explode('x', $key)) > 1 && isset($inf_accom['type']) && isset($inf_accom['dog'])) {
                        $ea = new Employee_accommodation();
                        $ea->employee_id = $employee->id;
                    }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                        $key = (int)$key;
                        $ea = Employee_accommodation::find($key);
                    }
                    if(isset($inf_accom['type'])){$ea->type = $inf_accom['type'];}
                    if(isset($inf_accom['dog'])){$ea->date_of_getting = Carbon::parse($inf_accom['dog']);}
                    if(isset($inf_accom['doo'])){$ea->date_of_ownership = Carbon::parse($inf_accom['doo']);}
                    if(isset($inf_accom['dol'])){$ea->date_of_leaving = Carbon::parse($inf_accom['dol']);}
                    if(isset($inf_accom['rent'])){$ea->rent = $inf_accom['rent'];}
                    if(isset($ea)){
                        if(!isset(Auth::user()->employee_id) && $ea->isDirty()){
                            $keys = array_keys($ea->getOriginal());
                            foreach ($keys as $dkey) {
                                $key2 = str_replace('_',' ',$dkey);
                                if($dkey != 'created_at' || $dkey != 'updated_at'){
                                    if (count(explode('x', $key)) > 1) {
                                        if(isset($ea[$dkey])){
                                            $employee->record_changelog()->create([
                                                'employee_id' => $employee->id,
                                                'user_id' => Auth::id(),
                                                'name' => 'Accommodation : ' . $key2,
                                                'old' => '',
                                                'new' => $ea[$dkey],
                                                'record_type' => 1,
                                            ]);
                                        }
                                    } elseif ($ea->isDirty($dkey)) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'Accommodation : '.$key2,
                                            'old' => $ea->getOriginal($dkey),
                                            'new' => $ea[$dkey],
                                            'record_type' => 2,
                                        ]);
                                    }
                                }
                            }
                        }
                        $ea->save();
                    }

                }
            }
            if(isset($request->remove)){
                $arr = explode(',',$request->remove);
                foreach ($arr as $arrv){
                    $data = explode('_',$arrv);
                    if(count($data) > 0){
                        if($data[0]=='phs'){
                            $promotion = Employee_promotion_higher_scale::find((int)$data[1]);
                            if(isset($promotion->id)){
                                if((int)$promotion->type == 1){
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => 'Service Promotion deleted',
                                        'old' => 'Rank : ' . $promotion->rank . '\n' .
                                            'Date of getting : ' . $promotion->date_of_getting . '\n'.
                                            'End date : ' . $promotion->end_date . '\n'.
                                            'Sanction date : ' . $promotion->sanction_date . '\n'.
                                            'Sanction number : ' . $promotion->sanction_number . '\n'.
                                            'Pay Grade : ' . $this->function->present_position_present_grade()[$promotion->pay_grade][0] . '\n'.
                                            'Basic Pay : ' . $promotion->basic_pay . '\n'.
                                            'Working place : ' . $promotion->working_place . '\n'.
                                            'Time scale : ' . $promotion->time_scale . '\n'
                                        ,
                                        'new' => '',
                                        'record_type' => 3,
                                    ]);
                                }elseif((int)$promotion->type == 2){
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => 'Service Pay scale Promotion deleted',
                                        'old' => 'Date of getting : ' . $promotion->date_of_getting . '\n'.
                                            'End date : ' . $promotion->end_date . '\n'.
                                            'Sanction date : ' . $promotion->sanction_date . '\n'.
                                            'Sanction number : ' . $promotion->sanction_number . '\n'.
                                            'Pay Grade : ' . $this->function->present_position_present_grade()[$promotion->pay_grade][0] . '\n'.
                                            'Basic Pay : ' . $promotion->basic_pay . '\n'.
                                            'Time scale : ' . $promotion->time_scale . '\n'

                                        ,
                                        'new' => '',
                                        'record_type' => 3,
                                    ]);
                                }

                                $promotion->delete();
                            }
                        }
                        if($data[0]=='tra'){
                            $promotion = EmployeeTransfer::find((int)$data[1]);
                            if(isset($promotion->id)){
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => 'Service Transfer information deleted',
                                    'old' => 'Start Date : ' . $promotion->start_date . '\n'.
                                        'End date : ' . $promotion->end_date . '\n'.
                                        'Sanction date : ' . $promotion->sanction_date . '\n'.
                                        'Sanction number : ' . $promotion->sanction_number . '\n'.
                                        'Working place : ' . $promotion->working_place . '\n'.
                                        'Rank : ' . $promotion->rank . '\n'
                                    ,
                                    'new' => '',
                                    'record_type' => 3,
                                ]);
                                $promotion->delete();
                            }
                        }
                        if($data[0]=='sc'){
                            $promotion = Employee_accommodation::find((int)$data[1]);
                            if(isset($promotion->id)){
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => 'Service Transfer information deleted',
                                    'old' => 'type : ' . $promotion->type . '\n'.
                                        'Date of getting : ' . $promotion->date_of_getting . '\n'.
                                        'Date of ownership : ' . $promotion->date_of_ownership . '\n'.
                                        'Date of leaving : ' . $promotion->date_of_leaving . '\n'.
                                        'Rent : ' . $promotion->rent . '\n'
                                    ,
                                    'new' => '',
                                    'record_type' => 3,
                                ]);
                                $promotion->delete();
                            }
                        }
                    }
                }
            }



            return redirect()->back()->with('type','success')->with('message','Updated Successfully');
        }
    }



    public function service_promotion(){
        $function = $this->function;
        return view('admin.employee.extra_partial_page.service_promotion',compact('function'));
    }
    public function service_transfer(){
        $function = $this->function;
        return view('admin.employee.extra_partial_page.service_transfer',compact('function'));
    }

    public function pay_scale_change(){
        $function = $this->function;
        return view('admin.employee.extra_partial_page.service_pay_scale_change',compact('function'));
    }

    public function service_accommodation(){
        return view('admin.employee.extra_partial_page.service_accommodation');
    }
}
