<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;

use App\Http\Controllers\FunctionController;
use App\Models\Employee;
use App\Models\Employee_bank_info;
use App\Models\Employee_family_info;
use App\Models\Employee_personal_info;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PersonalInfoController extends Controller
{
    /**
     * @var FunctionController
     */
    private $function;

    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }

    public function index($id){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            'employee_family_info',
            'employee_bank_info'
            )->findorfail($id);
        $function = $this->function;
        return view('admin.employee.personal_family',compact('employee','loggedin','function'));
    }
    public function db($id,Request $request){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
//        dd($request->all());

        $employee = Employee::find($id);
        if(isset($employee->id)){
//            $hw_ids = array();
            if(isset($request->per_hw) && count($request->per_hw) > 0){
                foreach ($request->per_hw as $key=>$per_hw){
                    if(count(explode('x',$key)) > 1 && isset($per_hw['name']) && isset($per_hw['dob']) && isset($per_hw['nid'])){
                        $familyinfo = new Employee_family_info();
                        $familyinfo->employee_id = $employee->id;
                        $familyinfo->husbandwife = 1;
                    }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                        $key = (int)$key;
                        $familyinfo = Employee_family_info::find($key);
//                        array_push($hw_ids,$key);
                    }
//                    dd($per_hw,$familyinfo);
                    if(isset($per_hw['nid'])){$familyinfo->nid = $per_hw['nid'];}
                    if(isset($per_hw['dob'])){$familyinfo->birthday = Carbon::parse($per_hw['dob'])->format("Y-m-d");}
                    if(isset($per_hw['name'])){$familyinfo->name_bangla = $per_hw['name'];}
                    if(isset($per_hw['name_en'])){$familyinfo->name_eng = $per_hw['name_en'];}
                    if(isset($per_hw['occupation'])){$familyinfo->occupation = $per_hw['occupation'];}
                    if(isset($per_hw['designation'])){$familyinfo->designation = $per_hw['designation'];}
                    if(isset($per_hw['police_station'])){$familyinfo->thana_id = (int)$per_hw['police_station'];}
                    if(isset($per_hw['district'])){$familyinfo->district_id = (int)$per_hw['district'];}
                    if(isset($per_hw['organisation'])){$familyinfo->organisation = $per_hw['organisation'];}
                    if(isset($per_hw['location'])){$familyinfo->location = $per_hw['location'];}
                    if(isset($familyinfo)){
                        $keys = array_keys($familyinfo->getOriginal());
                        foreach ($keys as $dkey) {
                            $key2 = str_replace('_',' ',$dkey);
                            if ($familyinfo->isDirty($dkey)) {
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => $familyinfo->getOriginal('name_eng').' '.$key2,
                                    'old' => $familyinfo->getOriginal($dkey),
                                    'new' => $familyinfo[$dkey],
                                    'record_type' => 2,
                                ]);
                            }
                        }
                        $familyinfo->save();
                    }

                }
            }
            if(isset($request->per_child) && count($request->per_child) > 0){
                foreach ($request->per_child as $key=>$per_child){
                    if(count(explode('x',$key)) > 1 && isset($per_child['dob']) && isset($per_child['name_en']) && isset($per_child['name_bn'])){
                        $familyinfo = new Employee_family_info();
                        $familyinfo->employee_id = $employee->id;
                        $familyinfo->child = 1;
                    }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                        $familyinfo = Employee_family_info::find((int)$key);
                    }
                    if(isset($per_child['typeofidentification'])){$familyinfo->typeofidentification = $per_child['typeofidentification'];}
                    if(isset($per_child['nid'])){$familyinfo->nid = $per_child['nid'];}
                    if(isset($per_child['dob'])){$familyinfo->birthday = Carbon::parse($per_child['dob'])->format("Y-m-d");}
                    if(isset($per_child['name_bn'])){$familyinfo->name_bangla = $per_child['name_bn'];}
                    if(isset($per_child['name_en'])){$familyinfo->name_eng = $per_child['name_en'];}
                    if(isset($per_child['relation'])){$familyinfo->relation = $per_child['relation'];}
                    if(isset($familyinfo)){
                        $keys = array_keys($familyinfo->getOriginal());
                        foreach ($keys as $dkey) {
                            $key2 = str_replace('_',' ',$dkey);
                            if ($familyinfo->isDirty($dkey)) {
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => $familyinfo->getOriginal('name_eng').' '.$key2,
                                    'old' => $familyinfo->getOriginal($dkey),
                                    'new' => $familyinfo[$dkey],
                                    'record_type' => 2,
                                ]);
                            }
                        }
                        $familyinfo->save();
                    }

                }
            }
            if(isset($request->per_dis_child) && count($request->per_dis_child) > 0){
                foreach ($request->per_dis_child as $key=>$per_child){
                    if(count(explode('x',$key)) > 1 && isset($per_child['name_bn']) && isset($per_child['dob']) && isset($per_child['name_en'])){
                        $familyinfo = new Employee_family_info();
                        $familyinfo->employee_id = $employee->id;
                        $familyinfo->child = 1;
                        $familyinfo->autistic = 1;
                    }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                        $familyinfo = Employee_family_info::find((int)$key);
                    }
                    if(isset($per_child['nid'])){$familyinfo->nid = $per_child['nid'];}
                    if(isset($per_child['dob'])){$familyinfo->birthday = Carbon::parse($per_child['dob'])->format("Y-m-d");}
                    if(isset($per_child['gender'])){$familyinfo->gander = $per_child['gender'];}
                    if(isset($per_child['name_bn'])){$familyinfo->name_bangla = $per_child['name_bn'];}
                    if(isset($per_child['name_en'])){$familyinfo->name_eng = $per_child['name_en'];}
                    if(isset($familyinfo)) {
                        $keys = array_keys($familyinfo->getOriginal());
                        foreach ($keys as $dkey) {
                            $key2 = str_replace('_', ' ', $dkey);
                            if ($familyinfo->isDirty($dkey)) {
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => $familyinfo->getOriginal('name_eng') . ' ' . $key2,
                                    'old' => $familyinfo->getOriginal($dkey),
                                    'new' => $familyinfo[$dkey],
                                    'record_type' => 2,
                                ]);
                            }
                        }

                        $familyinfo->save();
                    }
                }
            }

            if(isset($request->bank) && count($request->bank) > 0){
                if(isset($request->bank['account_name'])){
                    $employee_bank = $employee->employee_bank_info;
                    if(isset($employee_bank->employee_id)){
                        $bank = Employee_bank_info::find($employee_bank->id);
                    }else{
                        $bank = new Employee_bank_info();
                        $bank->employee_id = $employee->id;
                    }
                    $bank->account_name = $request->bank['account_name'];
                    if(isset($request->bank['account_number'])){$bank->number = (int)$request->bank['account_number'];}
                    if(isset($request->bank['account_type'])){$bank->type = (int)$request->bank['account_type'];}
                    if(isset($request->bank['bank_name'])){$bank->bank_name = $request->bank['bank_name'];}
                    if(isset($request->bank['branch_name'])){$bank->branch = $request->bank['branch_name'];}
                    if(isset($request->bank['routing_number'])){$bank->routing = (int)$request->bank['routing_number'];}
                    $bank->save();
                }
            }
        }

        if(isset($request->remove)){
           $arr = explode(',',$request->remove);
           foreach ($arr as $arrv){
               $data = explode('_',$arrv);
               if(count($data) > 0){
                   if(isset($data[1]) && count(explode('x',$data[1])) < 2) {
                       $familyinfo = Employee_family_info::find((int)$data[1]);
                       if (isset($familyinfo->id)) {
                           $employee->record_changelog()->create([
                               'employee_id' => $employee->id,
                               'user_id' => Auth::id(),
                               'name' => 'Family Member deleted',
                               'old' => 'Name Bangla: '.$familyinfo->name_bangla.'\n '.
                                   'Name English : '.$familyinfo->name_eng.'\n '.
                                   'NID : '.$familyinfo->nid.'\n '.
                                   'Date of birth :'.$familyinfo->dob.'\n '
                               ,
                               'new' => '',
                               'record_type' => 3,
                           ]);
                           $familyinfo->delete();
                       }
                   }
               }
           }
        }
//        if(isset($request->profile_avatar)){
//
//        }
//        if(isset($request->profile_avatar_remove)){
//
//        }




//        dd($request->all());

       return redirect()->back()->with('type','success')->with('message','Updated Successfully');
    }




    public function husbandwifeinfo(){
    $function = $this->function;
        return view('admin.employee.extra_partial_page.per_husband_wife_info',compact('function'));
    }
    public function per_children_info(){
        return view('admin.employee.extra_partial_page.per_children_info');
    }
    public function per_disabled_children_info(){
        return view('admin.employee.extra_partial_page.per_disabled_children_info');
    }
}
