<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;

use App\Http\Controllers\FunctionController;
use App\Models\Employee;
use App\Models\Employee_pension_nominee;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PensionNomineeController extends Controller
{
    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }
    public function index($id){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            'employee_pension_nominee'
        )->findorfail($id);
        $function = $this->function;
        return view('admin.employee.pension_nomenee',compact('employee','loggedin','function'));
    }
    public function db($id,Request $request)
    {
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::findorfail($id);
        if (isset($employee->id)) {
            if(isset($request->pen_nom) && count($request->pen_nom) > 0){
                foreach ($request->pen_nom as $key=>$lien){
                    if(count(explode('x',$key)) > 1){
                        $ea = new Employee_pension_nominee();
                        $ea->employee_id = $employee->id;
                    }else{
                        $key = (int)$key;
                        $ea = Employee_pension_nominee::find($key);
                    }
                    if(isset($lien['nid'])){$ea->nid_or_birth_certificate = $lien['nid'];}
                    if(isset($lien['dob'])){$ea->birth_date = Carbon::parse($lien['dob'])->format('Y-m-d');}
                    if(isset($lien['relation'])){$ea->relation = $lien['relation'];}
                    if(isset($lien['name_bn'])){$ea->name = $lien['name_bn'];}
                    if(isset($lien['name_en'])){$ea->name_en = $lien['name_en'];}
                    if(isset($lien['ms'])){$ea->marital_status = (int)$lien['ms'];}
                    if(isset($lien['das'])){$ea->disability = $lien['das'];}
                    if(isset($lien['dp'])){$ea->designated_part_percent = $lien['dp'];}
                    $ea->save();
                }
            }

            if(isset($request->remove)){
                $arr = explode(',',$request->remove);
                foreach ($arr as $arrv){
                    $data = explode('_',$arrv);
                    if(count($data) > 0){
                        if($data[0]=='pn'){
                            $promotion = Employee_pension_nominee::find((int)$data[1]);
                            if(isset($promotion->id)){
                                $promotion->delete();
                            }
                        }
                    }
                }
            }

            return redirect()->back()->with('type','success')->with('message','Updated Successfully');
        }
    }

    public function nomineepension(){
        $function = $this->function;
        return view('admin.employee.extra_partial_page.nomineepension',compact('function'));
    }
}
