<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;
use App\Http\Controllers\FunctionController;
use App\Models\Employee;
use App\Models\MonthlyPayslip;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PayslipController extends Controller
{
    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }
    public function index($month){
        if(!strtotime($month)){$month = Carbon::today();}
        $employees = Employee::with(['pay_slip_plus' => function ($query) use ($month) {
            $query->where('month', '>=', Carbon::parse($month)->firstOfMonth());
        },'pay_slip_minus' => function ($query) use ($month) {
            $query->where('month', '>=', Carbon::parse($month)->firstOfMonth());
        }])->with('employee_present_position')->get();
        $tk = array();
        $activecode1 = array();
        $activecode2 = array();
        foreach ($employees as $employee){
            if(!isset($tk[$employee->id])){$tk[$employee->id] = array();}
            foreach ($employee->pay_slip_plus as $pay_slip){
                $tk[$employee->id][$pay_slip->code] = $pay_slip->taka;
                if(!in_array($pay_slip->code,$activecode1) && isset($employee->employee_present_position->grade_no) && $employee->employee_present_position->grade_no <= 9){array_push($activecode1,(int)$pay_slip->code);}
                if(!in_array($pay_slip->code,$activecode2) && isset($employee->employee_present_position->grade_no) && $employee->employee_present_position->grade_no > 9){array_push($activecode2,(int)$pay_slip->code);}
            }
            foreach ($employee->pay_slip_minus as $pay_slip){
                $tk[$employee->id][$pay_slip->code] = $pay_slip->taka;
                if(!in_array($pay_slip->code,$activecode1) && isset($employee->employee_present_position->grade_no) && $employee->employee_present_position->grade_no <= 9){array_push($activecode1,(int)$pay_slip->code);}
                if(!in_array($pay_slip->code,$activecode2) && isset($employee->employee_present_position->grade_no) && $employee->employee_present_position->grade_no > 9){array_push($activecode2,(int)$pay_slip->code);}
            }
        }
//        dd($activecode1,$activecode2);
        $function = $this->function;
        return view('admin.payslip.index',compact('tk','function','month','employees','activecode1','activecode2'));
//        dd($tk,$employee,$employee->pay_slip_plus->sum('taka'));

    //       $function = $this->function;
    }
    public function show(Request $request){
       if(isset($request->old_month) && strtotime($request->old_month)){
           return redirect()->route('payslip.index',['month'=>$request->old_month]);
       }else{
           return redirect()->back()->with('type','danger')->with('message','Date format invalid');
       }

    }
    public function add(){
        $function = $this->function;
        return view('admin.payslip.add',compact('function'));
    }
    public function add_to_db(Request $request){
        if(Carbon::parse($request->month) > Carbon::today()->lastOfMonth()){
            return redirect()->back()->with('type','danger')->with('message','You can not select next month');
        }
        $payslipcodes = array();
        foreach ($request->payslip_code as $key=>$co){
            array_push($payslipcodes, $key);
        }
        $employees = Employee::with('pay_allowance_deduction','employee_present_position')->get();
        $tk = array();
        $tkcode = array();
        $deletetk = array();
        foreach ($employees as $employee){
            if(!isset($tk[$employee->id])){$tk[$employee->id] = array();}
            if(!isset($deletetk[$employee->id])){$deletetk[$employee->id] = array();}
            if(!isset($tkcode[$employee->id])){$tkcode[$employee->id] = array();}
            foreach ($employee->pay_allowance_deduction as $pay_slip){
                if(isset($pay_slip->taka) && $pay_slip->taka > 0 && in_array($pay_slip->code,$payslipcodes)){
                    $tk[$employee->id][$pay_slip->code] = $pay_slip->taka;
                    array_push($tkcode[$employee->id],$pay_slip->code);
                }else{
                    array_push($deletetk[$employee->id],$pay_slip->code);
                }
            }
        }

        foreach ($tk as $employee_id=>$paycode){
            $monthly_payslip_datas = MonthlyPayslip::where('employee_id',$employee_id)->where('month',Carbon::parse($request->month)->firstOfMonth())->get();
            foreach ($monthly_payslip_datas as $monthly_payslip_data){
                if(in_array($monthly_payslip_data->code,$tkcode[$employee_id])){
                    $key = array_search($monthly_payslip_data->code, $tkcode[$employee_id]);
                    unset($tkcode[$employee_id][$key]);
                    $monthly_payslip_data->taka = $tk[$employee_id][$monthly_payslip_data->code];
                    $monthly_payslip_data->save();
                }
                if(in_array($monthly_payslip_data->code,$deletetk[$employee_id])){
                    $monthly_payslip_data->delete();
                }
            }
            foreach ($paycode as $code=>$taka){
                if(in_array($code,$tkcode[$employee_id])){
                    $data = new MonthlyPayslip();
                    $data->employee_id = $employee_id;
                    $data->month = Carbon::parse($request->month)->firstOfMonth();
                    $data->code = $code;
                    if($this->function->pay_allowance()[$code][0] == 1){
                        $data->addition = 1;
                    }else{
                        $data->deduction = 1;
                    }
                    $data->taka = $taka;
                    $data->save();
                }
            }
        }
        return redirect()->route('payslip.index',['month'=>\Carbon\Carbon::parse($request->month)->format('Y-m-d')])->with('type','success')->with('message',\Carbon\Carbon::parse($request->month)->format('F,Y').'Payslip Successfully generated');

//       $function = $this->function;
    }
    public function employee_payslip($id){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}

        $start = Carbon::now();
        $end = Carbon::now();
//        dd((int)Carbon::today()->format('m'));
        if(!strtotime(\request()->start)) {
            if ((int)Carbon::today()->format('m') > 6) {
                $start = Carbon::today()->firstOfQuarter();
            }else{
                $start = Carbon::today()->firstOfQuarter()->modify('-6 month');
            }
        }else{
            $start = Carbon::parse(\request()->start)->firstOfMonth();
        }
        if(!strtotime(\request()->end)) {
            if ((int)Carbon::today()->format('m') > 6) {
                $end = Carbon::today()->firstOfQuarter()->modify('+1 year');
            }else{
                $end = Carbon::today()->endOfQuarter();
            }
        }else{
                $end = Carbon::parse(\request()->end)->lastOfMonth();
        }
        $employee = Employee::with('employee_present_position')->with(['pay_slip'=>function ($query) use ($start,$end){$query->where('month','>=',$start); $query->where('month','<=',$end);}])->find($id);
        $activecode1 = array();
        // return $employee;
        foreach ($employee->pay_slip as $pay_slip){
            if(!in_array($pay_slip->code,$activecode1)){array_push($activecode1,(int)$pay_slip->code);}
        }

        $function = $this->function;
        $additionCount=0;
        $deductionCount=0;

    foreach ($function->pay_allowance() as $key=>$allowance) {
       if ($allowance[0] == 0  && in_array($key,$activecode1)) {
        $deductionCount=$deductionCount+1;
       }
       elseif($allowance[0] == 1  && in_array($key,$activecode1)){
        $additionCount=$additionCount+1;
       }
       
    }

        
        // return $function->pay_allowance();
        return view('admin.employee.payslip',compact('function','employee','activecode1','start','end','additionCount','deductionCount'));
    }
}
   