<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;

use App\Http\Controllers\FunctionController;
use App\Models\Employee;
use App\Models\Employee_pay_allowance_deduction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PayAllowanceDeductionController extends Controller
{
    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }

    public function index($id){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            'pay_allowance_deduction','employee_present_address_with_zone','employee_present_position'
        )->withCount('total_child')->findorfail($id);
        $tk = array();
        foreach ($employee->pay_allowance_deduction as $pay_allowance_deduction){
            $tk[$pay_allowance_deduction->code] = $pay_allowance_deduction->taka;
        }
        $function = $this->function;
//        dd($employee->employee_present_address_with_zone->thana->zone);
//        dd($function->present_position_present_grade()[$employee->employee_present_position->grade][6]);
        return view('admin.employee.payallowance_deduction',compact('employee','tk','loggedin','function'));
    }
    public function db($id,Request $request){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            'pay_allowance_deduction'
        )->find($id);
        if(isset($employee->id)){
            if(isset($request->pay_allowance) && count($request->pay_allowance) > 0){
                foreach ($request->pay_allowance as $key=>$addition){
                    $ex = explode('_',$key);
                    if(count($ex) > 1){
                        $data = Employee_pay_allowance_deduction::where('code',$ex[0])->where('employee_id',$employee->id)->first();
                        if(!isset($data->id)){
                            $data = new Employee_pay_allowance_deduction();
                            $data->addition = 1;
                            $data->employee_id = $employee->id;
                            $new = 1;
                        }
                        $data->name = $ex[1];
                        $data->code = $ex[0];
                        if(isset($addition) && (double)$addition > 0) {
                            $data->taka = (double)$addition;
                        }else{
                            $data->taka = 0;
                        }
                        if(!isset(Auth::user()->employee_id)){
                            $keys = array_keys($data->getOriginal());
                            foreach ($keys as $dkey) {
                                if($dkey == 'taka' ) {
                                    $key2 = $data->name.' ['.$data->code.'] (+)';
                                    if (isset($new) && $new == 1) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => $key2,
                                            'old' => '',
                                            'new' => $data[$dkey],
                                            'record_type' => 1,
                                        ]);
                                    } elseif ($data->isDirty($dkey)) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => $key2,
                                            'old' => $data->getOriginal($dkey),
                                            'new' => $data[$dkey],
                                            'record_type' => 2,
                                        ]);
                                    }
                                }
                            }
                        }
                        $data->save();
                    }
                }
            }
            if(isset($request->pay_deduction) && count($request->pay_deduction) > 0){
                foreach ($request->pay_deduction as $key=>$addition){
                    $ex = explode('_',$key);
                    if(count($ex) > 1){
                        $data = Employee_pay_allowance_deduction::where('code',$ex[0])->where('employee_id',$employee->id)->first();
                        if(!isset($data->id)){
                            $data = new Employee_pay_allowance_deduction();
                            $data->deduction = 1;
                            $data->employee_id = $employee->id;
                        }
                        $data->name = $ex[1];
                        $data->code = $ex[0];
                        if(isset($addition) && (double)$addition > 0) {
                            $data->taka = (double)$addition;
                        }else{
                            $data->taka = 0;
                        }
                        $keys = array_keys($data->getOriginal());
                        foreach ($keys as $dkey) {
                            if($dkey == 'taka' ) {
                                $key2 = $data->name.' ['.$data->code.'] (-)';
                                if (isset($new) && $new == 1) {
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => $key2,
                                        'old' => '',
                                        'new' => $data[$dkey],
                                        'record_type' => 1,
                                    ]);
                                } elseif ($data->isDirty($dkey)) {
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => $key2,
                                        'old' => $data->getOriginal($dkey),
                                        'new' => $data[$dkey],
                                        'record_type' => 2,
                                    ]);
                                }
                            }
                        }
                        $data->save();
                    }
                }
            }

        }

        return redirect()->back()->with('type','success')->with('message','Updated Successfully');
    }
}
