<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;
use App\Http\Controllers\FunctionController;
use App\Models\Employee;
use App\Models\Employee_bank_info;
use App\Models\Employee_family_info;
use App\Models\Employee_personal_info;
use App\Models\EmployeeAddress;
use App\Models\EmployeeHounourRewards;
use App\Models\EmployeeLanguage;
use App\Models\EmployeeOtherservice;
use App\Models\EmployeePosingabroad;
use App\Models\EmployeeProfessionalQualification;
use App\Models\EmployeePublication;
use App\Models\EmployeeQualification;
use App\Models\EmployeeService;
use App\Models\EmployeeTrainings;
use App\Models\EmployeeTravels;
// use App\Models\EmployeeTravels;
// use App\Models\Language;
use Aqualink\District\Models\District;
use Aqualink\District\Models\Thana;
use App\Models\Language;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class InfoController extends Controller
{
    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }

    public function index($id){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            ['employee_personal_info','employee_present_address','employee_permanent_address','employee_language','employeequalification'=>function($q){ $q->orderBy('passing_year','asc'); },
            'employee_local_training','employee_foreign_training','employee_travel','employee_posingabroad','employee_professionalqualification',
            'employee_publication','employee_hounourrewards','employee_otherservice','employee_service','user']
        )->findorfail($id);
//        dd($employee);
        $function = $this->function;
        return view('admin.employee.personal_info',compact('employee','loggedin','function'));
    }

    public function db($id,Request $request){
        if($request->file('profile_avatar')){
            $validatedData = $request->validate([
                'profile_avatar' => ['required','mimes:jpg,bmp,png','max:1024','dimensions:max_width=360,min_width=320,max_height=440,min_height=400'],
            ]);
        }

        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::find($id);
        if(isset($employee->id)){
            $employee_personal_info = $employee->employee_personal_info;
            if(isset($employee_personal_info->employee_id)){
                $personalinfo = Employee_personal_info::find($employee_personal_info->id);
            }else{
                $personalinfo = new Employee_personal_info();
                $personalinfo->employee_id = $employee->id;
            }
            if(isset($request->gender)){$personalinfo->gender = $request->gender;}
            if(isset($request->fname)){$personalinfo->fname =$request->fname;}
            if(isset($request->mname)){$personalinfo->mname =$request->mname;}
            if(isset($request->religion)){$personalinfo->region =$request->religion;}
            if(isset($request->marital_status)){$personalinfo->marital_status = $request->marital_status;}
            if(isset($request->mobile)){$personalinfo->mobile_phone =$request->mobile;}
            if(isset($request->emergency_phone)){$personalinfo->emergency_phone =$request->emergency_phone;}
            if(isset($request->etin)){
                $personalinfo->tin =$request->etin;
            }
            if(isset($request->profile_avatar_remove)){
                $employee->image =  null;
                $employee->save();
            }
            if($request->file('profile_avatar'))
            {
                $image = $request->file('profile_avatar');
                $imageName = 'image_'.time().'.'.$image->getClientOriginalExtension();
                $image->move(public_path().'/upload/employeeimages/', $imageName);
                $imgpath = '/upload/employeeimages/'.$imageName;
                $employee->image =  $imgpath;
                $employee->save();
            }
            if($personalinfo->isDirty()){
                $keys = array_keys($personalinfo->getOriginal());
                foreach ($keys as $key){
                    if($personalinfo->isDirty($key)){
                        $savechange = $personalinfo->record_changelog();
                        $key2 = $key;
                        if($key == 'gender'){$key2 = 'Gender';}
                        if($key == 'fname'){$key2 = 'Father Name';}
                        if($key == 'mname'){$key2 = 'Mother Name';}
                        if($key == 'region'){$key2 = 'Region';}
                        if($key == 'marital_status'){$key2 = 'Marital Status';}
                        if($key == 'mobile_phone'){$key2 = 'Contact Number';}
                        if($key == 'emergency_phone'){$key2 = 'Emergency Contact Number';}
                        if($key == 'etin'){$key2 = 'TIN';}
                        if($key == 'gender'){
                            $savechange->create([
                                'employee_id'=> $employee->id,
                                'user_id'=> Auth::id(),
                                'name'=> $key2,
                                'old'=> $this->function->gender()[$personalinfo->getOriginal($key)][0],
                                'new'=> $this->function->gender()[$personalinfo[$key]][0],
                                'record_type' => 2,
                            ]);
                        }elseif($key == 'region'){
                            $savechange->create([
                                'employee_id'=> $employee->id,
                                'user_id'=> Auth::id(),
                                'name'=> $key2,
                                'old'=> $this->function->religion()[$personalinfo->getOriginal($key)][0],
                                'new'=> $this->function->religion()[$personalinfo[$key]][0],
                                'record_type' => 2,
                            ]);
                        }elseif($key == 'marital_status'){
                            $savechange->create([
                                'employee_id'=> $employee->id,
                                'user_id'=> Auth::id(),
                                'name'=> $key2,
                                'old'=> $this->function->marital_status()[$personalinfo->getOriginal($key)][0],
                                'new'=> $this->function->marital_status()[$personalinfo[$key]][0],
                                'record_type' => 2,
                            ]);
                        }else{

                            $savechange->create([
                                'employee_id'=> $employee->id,
                                'user_id'=> Auth::id(),
                                'name'=> $key2,
                                'old'=> $personalinfo->getOriginal($key),
                                'new'=> $personalinfo[$key],
                                'record_type' => 2,
                            ]);
                        }
                    }
                }

            }
            $personalinfo->save();

            if(isset($request->present_address) && count($request->present_address) > 0){
                $present_address = EmployeeAddress::where('employee_id',$employee->id)->where('permanent',0)->first();
                if(!isset($present_address->id)){
                    $present_address_newdata = 1;
                    $present_address = new EmployeeAddress();
                    $present_address->employee_id = $employee->id;
                }
                if(isset($request->present_address['village_or_house_road'])){$present_address->village_or_house_road = $request->present_address['village_or_house_road'];}
                if(isset($request->present_address['post_office'])){$present_address->post_office = $request->present_address['post_office'];}
                if(isset($request->present_address['police_station'])){$present_address->thana_id = (int)$request->present_address['police_station'];}
                if(isset($request->present_address['district'])){$present_address->district_id = (int)$request->present_address['district'];}
                if(isset($request->present_address['contact'])){$present_address->contact = $request->present_address['contact'];}
                if(!isset(Auth::user()->employee_id)){
                    $keys = array_keys($present_address->getOriginal());
                    foreach ($keys as $dkey) {
                        if($dkey != 'employee_id' || $dkey != 'permanent') {
                            $key2 = str_replace('_',' ',$dkey);
                            if (isset($present_address_newdata) && $present_address_newdata == 1) {
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => 'Present address - '.$key2,
                                    'old' => '',
                                    'new' => $present_address[$dkey],
                                    'record_type' => 1,
                                ]);
                            } elseif ($present_address->isDirty($dkey)) {
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => 'Present address - '.$key2,
                                    'old' => $present_address->getOriginal($dkey),
                                    'new' => $present_address[$dkey],
                                    'record_type' => 2,
                                ]);
                            }
                        }
                    }
                }
                $present_address->save();
            }
            if(isset($request->permanent_address) && count($request->permanent_address) > 0){
                $permanent_address = EmployeeAddress::where('employee_id',$employee->id)->where('permanent',1)->first();
                if(!isset($permanent_address->id)){
                    $permanent_address_newdata = 1;
                    $permanent_address = new EmployeeAddress();
                    $permanent_address->employee_id = $employee->id;
                    $permanent_address->permanent = 1;
                }
                if(isset($request->permanent_address['village_or_house_road'])){ $permanent_address->village_or_house_road = $request->permanent_address['village_or_house_road'];}
                if(isset($request->permanent_address['post_office'])){$permanent_address->post_office = $request->permanent_address['post_office'];}
                if(isset($request->permanent_address['police_station'])){$permanent_address->thana_id = (int)$request->permanent_address['police_station'];}
                if(isset($request->permanent_address['district'])){$permanent_address->district_id = (int)$request->permanent_address['district'];}
                if(isset($request->permanent_address['contact'])){$permanent_address->contact = $request->permanent_address['contact'];}
                if(!isset(Auth::user()->employee_id)){
                    $keys = array_keys($permanent_address->getOriginal());
                    foreach ($keys as $dkey) {
                        if($dkey != 'employee_id' || $dkey != 'permanent') {
                            $key2 = str_replace('_', ' ', $dkey);
                            if (isset($permanent_address_newdata) && $permanent_address_newdata == 1) {
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => 'Permanent address - ' . $key2,
                                    'old' => '',
                                    'new' => $permanent_address[$dkey],
                                    'record_type' => 1,
                                ]);
                            } elseif ($permanent_address->isDirty($dkey)) {
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => 'Permanent address - ' . $key2,
                                    'old' => $permanent_address->getOriginal($dkey),
                                    'new' => $permanent_address[$dkey],
                                    'record_type' => 2,
                                ]);
                            }
                        }
                    }
                }
                $permanent_address->save();
            }

            if(isset($request->per_language) && count($request->per_language) > 0){
                foreach ($request->per_language as $key=>$per_language){
                        if(count(explode('x',$key)) > 1 && isset($per_language['name'])){
                            $language = new EmployeeLanguage();
                            $language->employee_id = $employee->id;
                            $language->name = $per_language['name'];
                        }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                            $language = EmployeeLanguage::find((int)$key);
                        }
                        if(isset($per_language['read'])){$language->read = 1;} else {$language->read = 0;}
                        if(isset($per_language['write'])){$language->write = 1;} else {$language->write = 0;}
                        if(isset($per_language['speak'])){$language->speak = 1;} else {$language->speak = 0;}
                        if(isset($language)){$language->save();}


                }
            }
            if(isset($request->personal_edu_qua) && count($request->personal_edu_qua) > 0){
                foreach ($request->personal_edu_qua as $key=>$personal_edu_qua){
                    if(count(explode('x',$key)) > 1 && isset($personal_edu_qua['institute']) && isset($personal_edu_qua['edu_type'])){
                        $eduqualification = new EmployeeQualification();
                        $eduqualification->employee_id = $employee->id;
                    }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                        $eduqualification = EmployeeQualification::find((int)$key);
                    }

                    if(isset($personal_edu_qua['institute'])){$eduqualification->institute = $personal_edu_qua['institute'];}
                    if(isset($personal_edu_qua['edu_type'])){$eduqualification->edu_type = $personal_edu_qua['edu_type'];}

                    if(isset($personal_edu_qua['subject'])){$eduqualification->subject = $personal_edu_qua['subject'];}
                    if(isset($personal_edu_qua['degree'])){$eduqualification->degree = $personal_edu_qua['degree'];}
                    if(isset($personal_edu_qua['passing_year'])){$eduqualification->passing_year = $personal_edu_qua['passing_year'];}
                    if(isset($personal_edu_qua['result'])){$eduqualification->result = $personal_edu_qua['result'];}
                    if(isset($personal_edu_qua['gpa'])){$eduqualification->gpa = $personal_edu_qua['gpa'];}
                    if(isset($personal_edu_qua['distinction'])){$eduqualification->distinction = $personal_edu_qua['distinction'];}
                    if(isset($personal_edu_qua['group'])){$eduqualification->group = $personal_edu_qua['group'];}

                    if(!isset(Auth::user()->employee_id) && isset($eduqualification)){
                        $keys = array_keys($eduqualification->getOriginal());
                        foreach ($keys as $dkey) {
                            if($dkey != 'employee_id') {
                                $key2 = str_replace('_', ' ', $dkey);
                                if (count(explode('x', $key)) > 1) {
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => 'Educational Qualification - ' . $eduqualification->degree . ' : ' . $key2,
                                        'old' => '',
                                        'new' => $eduqualification[$dkey],
                                        'record_type' => 1,
                                    ]);
                                } elseif ($eduqualification->isDirty($dkey)) {
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => 'Educational Qualification - ' . $eduqualification->degree . ' : ' . $key2,
                                        'old' => $eduqualification->getOriginal($dkey),
                                        'new' => $eduqualification[$dkey],
                                        'record_type' => 2,
                                    ]);
                                }
                            }
                        }
                    }
                    if(isset($eduqualification)){
                        $eduqualification->save();
                    }

                }
            }
            if(isset($request->personal_local_training) && count($request->personal_local_training) > 0){
                foreach ($request->personal_local_training as $key=>$personal_local_training){
                    if (count(explode('x', $key)) > 1 && isset($personal_local_training['course_title']) && isset($personal_local_training['institution'])) {
                        $training = new EmployeeTrainings();
                        $training->employee_id = $employee->id;
                    }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                        $training = EmployeeTrainings::find((int)$key);
                    }
                    if(isset($personal_local_training['course_title'])){$training->course_title = $personal_local_training['course_title'];}
                    if(isset($personal_local_training['institution'])){$training->institution = $personal_local_training['institution'];}
                    if (isset($personal_local_training['from'])) {
                        $training->from = Carbon::parse($personal_local_training['from'])->format('Y-m-d');
                    }
                    if (isset($personal_local_training['to'])) {
                        $training->to = Carbon::parse($personal_local_training['to'])->format('Y-m-d');
                    }
                    if (isset($personal_local_training['grade'])) {
                        $training->grade = $personal_local_training['grade'];
                    }
                    if (isset($personal_local_training['position'])) {
                        $training->position = $personal_local_training['position'];
                    }
                    if (isset($personal_local_training['country'])) {
                        $training->country = $personal_local_training['country'];
                    }
                    if (!isset(Auth::user()->employee_id) && isset($training)) {
                        $keys = array_keys($training->getOriginal());
                        foreach ($keys as $dkey) {
                            if ($dkey != 'employee_id') {
                                $key2 = str_replace('_', ' ', $dkey);
                                if (count(explode('x', $key)) > 1) {
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => 'Local Training ( ' . $training->course_title . ' ) ' . $key2,
                                        'old' => '',
                                        'new' => $training[$dkey],
                                        'record_type' => 1,
                                    ]);
                                } elseif ($training->isDirty($dkey)) {
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => 'Local Training ( ' . $training->course_title . ' ) ' . $key2,
                                        'old' => $training->getOriginal($dkey),
                                        'new' => $training[$dkey],
                                        'record_type' => 2,
                                    ]);
                                }
                            }
                        }
                    }
                    if(isset($training)){$training->save();}


                }
            }
            if(isset($request->personal_foreign_training) && count($request->personal_foreign_training) > 0){
                foreach ($request->personal_foreign_training as $key=>$personal_foreign_training){
                    if (count(explode('x', $key)) > 1 && isset($personal_foreign_training['course_title']) && isset($personal_foreign_training['travel_type'])) {
                        $training = new EmployeeTrainings();
                        $training->employee_id = $employee->id;
                        $training->is_foreign = 1;
                    }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                        $training = EmployeeTrainings::find((int)$key);
                    }
                    if(isset($personal_foreign_training['travel_type'])){$training->travel_type = (int)$personal_foreign_training['travel_type'];}
                    if(isset($personal_foreign_training['course_title'])){$training->course_title = $personal_foreign_training['course_title'];}
                    if(isset($personal_foreign_training['institution'])){$training->institution = $personal_foreign_training['institution'];}
                    if (isset($personal_foreign_training['from'])) {
                        $training->from = Carbon::parse($personal_foreign_training['from'])->format('Y-m-d');
                    }
                    if (isset($personal_foreign_training['to'])) {
                        $training->to = Carbon::parse($personal_foreign_training['to'])->format('Y-m-d');
                    }
                    if (isset($personal_foreign_training['grade'])) {
                        $training->grade = $personal_foreign_training['grade'];
                    }
                    if (isset($personal_foreign_training['position'])) {
                        $training->position = $personal_foreign_training['position'];
                    }
                    if (isset($personal_foreign_training['country'])) {
                        $training->country = $personal_foreign_training['country'];
                    }
                    if (isset($personal_foreign_training['sanction_number'])) {
                        $training->sanction_number = $personal_foreign_training['sanction_number'];
                    }
                    if (isset($personal_foreign_training['sanction_date'])) {
                        $training->sanction_date = Carbon::parse($personal_foreign_training['sanction_date'])->format('Y-m-d');
                    }
                    if (!isset(Auth::user()->employee_id) && isset($training)) {
                        $keys = array_keys($training->getOriginal());
                        foreach ($keys as $dkey) {
                            if ($dkey != 'employee_id' || $dkey != 'is_foreign') {
                                $key2 = str_replace('_', ' ', $dkey);
                                if (count(explode('x', $key)) > 1) {
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => 'Foreign Training ( ' . $training->course_title . ' ) ' . $key2,
                                        'old' => '',
                                        'new' => $training[$dkey],
                                        'record_type' => 1,
                                    ]);
                                } elseif ($training->isDirty($dkey)) {
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => 'Foreign Training ( ' . $training->course_title . ' ) ' . $key2,
                                        'old' => $training->getOriginal($dkey),
                                        'new' => $training[$dkey],
                                        'record_type' => 2,
                                    ]);
                                }
                            }
                        }
                    }
                    if(isset($training)){
                        $training->save();
                    }


                }
            }
            //-----------------
//            if(isset($request->personal_foreign_travel) && count($request->personal_foreign_travel) > 0){
//                foreach ($request->personal_foreign_travel as $key=>$personal_foreign_travel){
//                        if (count(explode('x', $key)) > 1 && isset($personal_foreign_travel['country'])) {
//                            $for_travel = new EmployeeTravels();
//                            $for_travel->employee_id = $employee->id;
//                        }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
//                            $for_travel = EmployeeTravels::find((int)$key);
//                        }
//                        if(isset($personal_foreign_travel['country'])){$for_travel->country = $personal_foreign_travel['country'];}
//                        if (isset($personal_foreign_travel['purpose'])) {
//                            $for_travel->purpose = $personal_foreign_travel['purpose'];
//                        }
//                        if (isset($personal_foreign_travel['from'])) {
//                            $for_travel->from = Carbon::parse($personal_foreign_travel['from'])->format('Y-m-d');
//                        }
//                        if (isset($personal_foreign_travel['to'])) {
//                            $for_travel->to = Carbon::parse($personal_foreign_travel['to'])->format('Y-m-d');
//                        }
//                        if (!isset(Auth::user()->employee_id) && isset($for_travel)) {
//                            $keys = array_keys($for_travel->getOriginal());
//                            foreach ($keys as $dkey) {
//                                if ($dkey != 'employee_id') {
//                                    $key2 = str_replace('_', ' ', $dkey);
//                                    if (count(explode('x', $key)) > 1) {
//                                        $employee->record_changelog()->create([
//                                            'employee_id' => $employee->id,
//                                            'user_id' => Auth::id(),
//                                            'name' => 'Foreign Travel ( ' . $for_travel->country . ' ) ' . $key2,
//                                            'old' => '',
//                                            'new' => $for_travel[$dkey],
//                                            'record_type' => 1,
//                                        ]);
//                                    } elseif ($for_travel->isDirty($dkey)) {
//                                        $employee->record_changelog()->create([
//                                            'employee_id' => $employee->id,
//                                            'user_id' => Auth::id(),
//                                            'name' => 'Foreign Travel ( ' . $for_travel->country . ' ) ' . $key2,
//                                            'old' => $for_travel->getOriginal($dkey),
//                                            'new' => $for_travel[$dkey],
//                                            'record_type' => 2,
//                                        ]);
//                                    }
//                                }
//                            }
//                        }
//                        if(isset($for_travel)){
//                            $for_travel->save();
//                        }
//                }
//            }
            if(isset($request->personal_posting_abroad) && count($request->personal_posting_abroad) > 0){
                foreach ($request->personal_posting_abroad as $key=>$personal_posting_abroad){
                        if (count(explode('x', $key)) > 1 && isset($personal_posting_abroad['country'])) {
                            $posting_abroad = new EmployeePosingabroad();
                            $posting_abroad->employee_id = $employee->id;
                        }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                            $posting_abroad = EmployeePosingabroad::find((int)$key);
                        }
                        if (isset($personal_posting_abroad['post'])) {
                            $posting_abroad->post = $personal_posting_abroad['post'];
                        }
                        if (isset($personal_posting_abroad['organisation'])) {
                            $posting_abroad->organization = $personal_posting_abroad['organisation'];
                        }
                        if(isset($personal_posting_abroad['country'])){$posting_abroad->country = $personal_posting_abroad['country'];}
                        if (isset($personal_posting_abroad['from'])) {
                            $posting_abroad->from = Carbon::parse($personal_posting_abroad['from'])->format('Y-m-d');
                        }
                        if (isset($personal_posting_abroad['to'])) {
                            $posting_abroad->to = Carbon::parse($personal_posting_abroad['to'])->format('Y-m-d');
                        }
                        if (!isset(Auth::user()->employee_id) && isset($posting_abroad)) {
                            $keys = array_keys($posting_abroad->getOriginal());
                            foreach ($keys as $dkey) {
                                if ($dkey != 'employee_id') {
                                    $key2 = str_replace('_', ' ', $dkey);
                                    if (count(explode('x', $key)) > 1) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'Posting Abroad ( ' . $posting_abroad->post . ' ) ' . $key2,
                                            'old' => '',
                                            'new' => $posting_abroad[$dkey],
                                            'record_type' => 1,
                                        ]);
                                    } elseif ($posting_abroad->isDirty($dkey)) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'Posting Abroad ( ' . $posting_abroad->post . ' ) ' . $key2,
                                            'old' => $posting_abroad->getOriginal($dkey),
                                            'new' => $posting_abroad[$dkey],
                                            'record_type' => 2,
                                        ]);
                                    }
                                }
                            }
                        }
                        if(isset($posting_abroad)){
                        $posting_abroad->save();
                    }
                }
            }
            if(isset($request->personal_professional_qualification) && count($request->personal_professional_qualification) > 0){
                foreach ($request->personal_professional_qualification as $key=>$personal_professional_qualification){
                        if (count(explode('x', $key)) > 1 && isset($personal_professional_qualification['qualification'])) {
                            $qualification = new EmployeeProfessionalQualification();
                            $qualification->employee_id = $employee->id;
                        }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                            $qualification = EmployeeProfessionalQualification::find((int)$key);
                        }
                        if ( isset($personal_professional_qualification['qualification'])){ $qualification->name = $personal_professional_qualification['qualification']; }
                        if (isset($personal_professional_qualification['rating'])) {
                            $qualification->rate = $personal_professional_qualification['rating'];
                        }
                        if(isset($qualification)){
                        $qualification->save();
                    }
                }
            }
            if(isset($request->personal_publication) && count($request->personal_publication) > 0){
                foreach ($request->personal_publication as $key=>$personal_publication){
                        if (count(explode('x', $key)) > 1 && isset($personal_publication['type']) && isset($personal_publication['title'])) {
                            $publication = new EmployeePublication();
                            $publication->employee_id = $employee->id;
                        }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                            $publication = EmployeePublication::find((int)$key);
                        }
                        if(isset($personal_publication['type'])){$publication->type = (int)$personal_publication['type'];}
                        if(isset($personal_publication['title'])){$publication->title = $personal_publication['title'];}
                        if (isset($personal_publication['description'])) {
                            $publication->description = $personal_publication['description'];
                        }
                        if (isset($personal_publication['date'])) {
                            $publication->date = Carbon::parse($personal_publication['date'])->format('Y-m-d');
                        }
                        if (!isset(Auth::user()->employee_id) && isset($publication)) {
                            $keys = array_keys($publication->getOriginal());
                            foreach ($keys as $dkey) {
                                if ($dkey != 'employee_id') {
                                    $key2 = str_replace('_', ' ', $dkey);
                                    if (count(explode('x', $key)) > 1) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'Publication ( ' . $publication->title . ' ) ' . $key2,
                                            'old' => '',
                                            'new' => $publication[$dkey],
                                            'record_type' => 1,
                                        ]);
                                    } elseif ($publication->isDirty($dkey)) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'Publication ( ' . $publication->title . ' ) ' . $key2,
                                            'old' => $publication->getOriginal($dkey),
                                            'new' => $publication[$dkey],
                                            'record_type' => 2,
                                        ]);
                                    }
                                }
                            }
                        }
                        if(isset($publication)){
                        $publication->save();
                    }
                }
            }
            if(isset($request->personal_honour_award) && count($request->personal_honour_award) > 0){
                foreach ($request->personal_honour_award as $key=>$personal_honour_award){
                        if (count(explode('x', $key)) > 1 && isset($personal_honour_award['title'])) {
                            $honour_award = new EmployeeHounourRewards();
                            $honour_award->employee_id = $employee->id;
                        }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                            $honour_award = EmployeeHounourRewards::find((int)$key);
                        }
                        if(isset($personal_honour_award['title'])){$honour_award->title = $personal_honour_award['title'];}
                        if (isset($personal_honour_award['ground'])) {
                            $honour_award->ground = $personal_honour_award['ground'];
                        }
                        if (isset($personal_honour_award['date'])) {
                            $honour_award->time = Carbon::parse($personal_honour_award['date'])->format('Y-m-d');
                        }
                        if (!isset(Auth::user()->employee_id) && isset($honour_award)) {
                            $keys = array_keys($honour_award->getOriginal());
                            foreach ($keys as $dkey) {
                                if ($dkey != 'employee_id') {
                                    $key2 = str_replace('_', ' ', $dkey);
                                    if (count(explode('x', $key)) > 1) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'Honour and Award ( ' . $honour_award->title . ' ) ' . $key2,
                                            'old' => '',
                                            'new' => $honour_award[$dkey],
                                            'record_type' => 1,
                                        ]);
                                    } elseif ($honour_award->isDirty($dkey)) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'Honour and Award  ( ' . $honour_award->title . ' ) ' . $key2,
                                            'old' => $honour_award->getOriginal($dkey),
                                            'new' => $honour_award[$dkey],
                                            'record_type' => 2,
                                        ]);
                                    }
                                }
                            }
                        }
                        if(isset($honour_award)){
                        $honour_award->save();
                    }
                }
            }
            if(isset($request->personal_other_service) && count($request->personal_other_service) > 0){
                foreach ($request->personal_other_service as $key=>$personal_other_service){
                        if (count(explode('x', $key)) > 1 && isset($personal_other_service['institute'])) {
                            $otherservice = new EmployeeOtherservice();
                            $otherservice->employee_id = $employee->id;
                        }elseif(count(explode('x',$key)) == 1 && (int)$key > 0){
                            $otherservice = EmployeeOtherservice::find((int)$key);
                        }
                        if(isset($personal_other_service['institute'])){$otherservice->name = $personal_other_service['institute'];}
                        if (isset($personal_other_service['address'])) {
                            $otherservice->address = $personal_other_service['address'];
                        }
                        if (isset($personal_other_service['type_of_service'])) {
                            $otherservice->type_of_service = $personal_other_service['type_of_service'];
                        }
                        if (isset($personal_other_service['position'])) {
                            $otherservice->position = $personal_other_service['position'];
                        }
                        if (isset($personal_other_service['from'])) {
                            $otherservice->from = Carbon::parse($personal_other_service['from'])->format('Y-m-d');
                        }
                        if (isset($personal_other_service['to'])) {
                            $otherservice->to = Carbon::parse($personal_other_service['to'])->format('Y-m-d');
                        }
                        if (!isset(Auth::user()->employee_id) && isset($otherservice)) {
                            $keys = array_keys($otherservice->getOriginal());
                            foreach ($keys as $dkey) {
                                if ($dkey != 'employee_id') {
                                    $key2 = str_replace('_', ' ', $dkey);
                                    if (count(explode('x', $key)) > 1) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'Other Service ( ' . $otherservice->name . ' ) ' . $key2,
                                            'old' => '',
                                            'new' => $otherservice[$dkey],
                                            'record_type' => 1,
                                        ]);
                                    } elseif ($otherservice->isDirty($dkey)) {
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'Other Service ( ' . $otherservice->name . ' ) ' . $key2,
                                            'old' => $otherservice->getOriginal($dkey),
                                            'new' => $otherservice[$dkey],
                                            'record_type' => 2,
                                        ]);
                                    }
                                }
                            }
                        }
                        if(isset($otherservice)){
                        $otherservice->save();
                    }
                }
            }

//            if(isset($request->personal_service_history) && count($request->personal_service_history) > 0){
//                if(isset($request->personal_service_history['govt_service_date'])) {
//                    $service_history = EmployeeService::where('employee_id', $employee->id)->first();
//                    if (!isset($service_history->id)) {
//                        $service_history = new EmployeeService();
//                        $service_history->employee_id = $employee->id;
//                        $new = 1;
//                    }
//                    $service_history->service_date = Carbon::parse($request->personal_service_history['govt_service_date'])->format('Y-m-d');
//                    if (isset($request->personal_service_history['gazetted_date'])) {
//                        $service_history->gazetted_date = Carbon::parse($request->personal_service_history['gazetted_date'])->format('Y-m-d');
//                    }
//                    if (isset($request->personal_service_history['encadrement_date'])) {
//                        $service_history->encadrement_date = Carbon::parse($request->personal_service_history['encadrement_date'])->format('Y-m-d');
//                    }
//                    if (isset($request->personal_service_history['seniority_date'])) {
//                        $service_history->seniority_date = Carbon::parse($request->personal_service_history['seniority_date'])->format('Y-m-d');
//                    }
//                    if (isset($request->personal_service_history['cadre'])) {
//                        $service_history->cadre = $request->personal_service_history['cadre'];
//                    }
//                    if (!isset(Auth::user()->employee_id)) {
//                        $keys = array_keys($service_history->getOriginal());
//                        foreach ($keys as $dkey) {
//                            if ($dkey != 'employee_id') {
//                                $key2 = str_replace('_', ' ', $dkey);
//                                if (isset($new) && $new = 1) {
//                                    $employee->record_changelog()->create([
//                                        'employee_id' => $employee->id,
//                                        'user_id' => Auth::id(),
//                                        'name' => 'Service History ' . $key2,
//                                        'old' => '',
//                                        'new' => $service_history[$dkey],
//                                        'record_type' => 1,
//                                    ]);
//                                } elseif ($service_history->isDirty($dkey)) {
//                                    $employee->record_changelog()->create([
//                                        'employee_id' => $employee->id,
//                                        'user_id' => Auth::id(),
//                                        'name' => 'Service History ' . $key2,
//                                        'old' => $service_history->getOriginal($dkey),
//                                        'new' => $service_history[$dkey],
//                                        'record_type' => 2,
//                                    ]);
//                                }
//                            }
//                        }
//                    }
//                    $service_history->save();
//                }
//            }
        }



        if(isset($request->remove)){
            $arr = explode(',',$request->remove);
            foreach ($arr as $arrv){
                $data = explode('_',$arrv);
                if(count($data) > 0){
                    if($data[0]=='perlan'){
                        $mdata = EmployeeLanguage::find((int)$data[1]);
                        if(isset($mdata->id)) {
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'Language deleted',
                                'old' => 'name : ' . $mdata->name . '\n' .
                                    'read : ' . $mdata->read . '\n' .
                                    'write : ' . $mdata->write . '\n' .
                                    'speak :' . $mdata->speak . '\n'
                                ,
                                'new' => '',
                                'record_type' => 3,
                            ]);
                            $mdata->delete();
                        }
                    }
                    if($data[0]=='pereduqua'){
                        $mdata = EmployeeQualification::find((int)$data[1]);
                        if(isset($mdata->id)){
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'Educational Qualification deleted',
                                'old' => 'Institute : ' . $mdata->institute . '\n' .
                                    'Subject : ' . $mdata->subject . '\n' .
                                    'Degree : ' . $mdata->degree . '\n' .
                                    'Passing Year :' . $mdata->passing_year . '\n'.
                                    'Gpa :' . $mdata->gpa . '\n'.
                                    'Distinction :' . $mdata->distinction . '\n'
                                ,
                                'new' => '',
                                'record_type' => 3,
                            ]);
                            $mdata->delete();
                        }
                    }
                    if($data[0]=='emlocaltraining'){
                        $mdata = EmployeeTrainings::find((int)$data[1]);
                        if(isset($mdata->id)){
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'Educational Local Training deleted',
                                'old' => 'Course Title : ' . $mdata->course_title . '\n' .
                                    'Institution : ' . $mdata->institution . '\n' .
                                    'From : ' . $mdata->from . '\n' .
                                    'To :' . $mdata->to . '\n'.
                                    'Grade :' . $mdata->grade . '\n'.
                                    'Position :' . $mdata->position . '\n'

                                ,
                                'new' => '',
                                'record_type' => 3,
                            ]);
                            $mdata->delete();
                        }
                    }
                    if($data[0]=='emfortraining'){
                        $mdata = EmployeeTrainings::find((int)$data[1]);
                        if(isset($mdata->id)){
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'Educational Foreign Training deleted',
                                'old' => 'Type : ' . $this->function->travel_types[$mdata->travel_type] . '\n' .
                                    'Course Title : ' . $mdata->course_title . '\n' .
                                    'Institution : ' . $mdata->institution . '\n' .
                                    'From : ' . $mdata->from . '\n' .
                                    'To :' . $mdata->to . '\n'.
                                    'Grade :' . $mdata->grade . '\n'.
                                    'Position :' . $mdata->position . '\n'.
                                    'Country :' . $mdata->country . '\n'.
                                    'sanction date :' . $mdata->sanction_date . '\n'.
                                    'sanction number :' . $mdata->sanction_number . '\n'
                                ,
                                'new' => '',
                                'record_type' => 3,
                            ]);
                            $mdata->delete();
                        }
                    }
                    if($data[0]=='emptravel'){
                        $mdata = EmployeeTravels::find((int)$data[1]);
                        if(isset($mdata->id)){
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'Travel information deleted',
                                'old' => 'Country : ' . $mdata->country . '\n' .
                                    'Purpose : ' . $mdata->purpose . '\n' .
                                    'From : ' . $mdata->from . '\n' .
                                    'To :' . $mdata->to . '\n'
                                ,
                                'new' => '',
                                'record_type' => 3,
                            ]);
                            $mdata->delete();
                        }
                    }
                    if($data[0]=='emppostingabr'){
                        $mdata = EmployeePosingabroad::find((int)$data[1]);
                        if(isset($mdata->id)){
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'Posting abroad information deleted',
                                'old' => 'Post : ' . $mdata->post . '\n' .
                                    'Organization : ' . $mdata->organization . '\n' .
                                    'Country : ' . $mdata->country . '\n' .
                                    'From :' . $mdata->from . '\n'.
                                    'To :' . $mdata->to . '\n'
                                ,
                                'new' => '',
                                'record_type' => 3,
                            ]);
                            $mdata->delete();
                        }
                    }
                    if($data[0]=='empproqua'){
                        $mdata = EmployeeProfessionalQualification::find((int)$data[1]);
                        if(isset($mdata->id)){
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'Professional Qualification deleted',
                                'old' => 'Name : ' . $mdata->name . '\n' .
                                    'Rate : ' . $mdata->rate . '\n'
                                ,
                                'new' => '',
                                'record_type' => 3,
                            ]);
                            $mdata->delete();
                        }
                    }
                    if($data[0]=='emppub'){
                        $mdata = EmployeePublication::find((int)$data[1]);
                        if(isset($mdata->id)){
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'Publication deleted',
                                'old' => 'Type : ' . $this->function->publication_name()[$mdata->type] . '\n' .
                                    'Title : ' . $mdata->title . '\n'.
                                    'Description : ' . $mdata->description . '\n'.
                                    'Date : ' . $mdata->date . '\n'
                                ,
                                'new' => '',
                                'record_type' => 3,
                            ]);
                            $mdata->delete();
                        }
                    }
                    if($data[0]=='emphonour'){
                        $mdata = EmployeeHounourRewards::find((int)$data[1]);
                        if(isset($mdata->id)){
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'Honour and Reward deleted',
                                'old' => 'Title : ' . $mdata->title . '\n'.
                                    'Ground : ' . $mdata->ground . '\n'.
                                    'Time : ' . $mdata->time . '\n'
                                ,
                                'new' => '',
                                'record_type' => 3,
                            ]);
                            $mdata->delete();
                        }
                    }
                }
            }
        }


//        if(isset($request->profile_avatar)){
//
//        }
//        if(isset($request->profile_avatar_remove)){
//
//        }
//        dd($request->all());

        return redirect()->back()->with('type','success')->with('message','Updated Successfully');
    }

    public function personal_language(){
        $function = $this->function;
        $languages = Language::all();
        return view('admin.employee.extra_partial_page.per_language',compact('languages','function'));
    }
    public function educational_qualification(){
        $function = $this->function;
        return view('admin.employee.extra_partial_page.per_educational_qualification',compact('function'));
    }
    public function local_training(){
        return view('admin.employee.extra_partial_page.per_local_training');
    }
    public function foreign_training(){
        $function = $this->function;
        return view('admin.employee.extra_partial_page.per_foreign_training',compact('function'));
    }
    public function foreign_travel(){
        return view('admin.employee.extra_partial_page.per_foreign_travel');
    }
    public function posting_abroad(){
        return view('admin.employee.extra_partial_page.per_posting_abroad');
    }
    public function professional_qualification(){
        return view('admin.employee.extra_partial_page.per_professional_qualification');
    }
    public function publication(){
        $function = $this->function;
        return view('admin.employee.extra_partial_page.per_publication',compact('function'));
    }
    public function honour_reward(){
        return view('admin.employee.extra_partial_page.per_honours_and_award');
    }
    public function other_service(){
        return view('admin.employee.extra_partial_page.per_other_service');
    }









// faisal---------------------------

public function employinfopdf($id)
    {
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            ['employee_personal_info','employee_present_address','employee_permanent_address','employee_language','employeequalification'=>function($q){ $q->orderBy('passing_year','asc');},
            'employee_local_training'=>function($q){ $q->orderBy('from','asc');},'employee_foreign_training'=>function($q){ $q->orderBy('from','asc');},'employee_professionalqualification',
            'employee_publication','employee_hounourrewards','employee_otherservice','employee_service','employee_family_info','employee_bank_info',
            'employee_first_joining','employee_present_position','employee_promotion_higher_scale'=>function($q){ $q->orderBy('date_of_getting','asc');},
            'employee_transfer'=>function($q){ $q->orderBy('start_date','asc');},'pay_allowance_deduction','employee_gpf',
            'employee_gpf_advance','employee_loan','employee_leave_lien','employee_desciplinary_action','employee_pension_nominee','employee_gpf_nominee'
            ,'employee_accommodation','employee_authorized_leave','rest_and_recreation']
        )->findorfail($id);

        $function = $this->function;

        // return $employee;
        return view('admin.employee.employeeinfo.employeeinfo',compact('employee','function'));
    }

    public function employinfoshortpdf($id)
    {
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            ['employee_personal_info','employee_present_address','employee_permanent_address','employee_language','employeequalification'=>function($q){ $q->orderBy('passing_year','asc');},
            'employee_local_training'=>function($q){ $q->orderBy('from','asc');},'employee_foreign_training'=>function($q){ $q->orderBy('from','asc');},'employee_professionalqualification',
            'employee_publication','employee_hounourrewards','employee_otherservice','employee_service','employee_family_info','employee_bank_info',
            'employee_first_joining','employee_present_position','employee_promotion_higher_scale'=>function($q){ $q->orderBy('date_of_getting','asc');},
            'employee_transfer'=>function($q){ $q->orderBy('start_date','asc');},'pay_allowance_deduction','employee_gpf',
            'employee_gpf_advance','employee_loan','employee_leave_lien','employee_desciplinary_action','employee_pension_nominee','employee_gpf_nominee'
            ,'employee_accommodation','employee_authorized_leave','rest_and_recreation']
        )->findorfail($id);

        $function = $this->function;

        // return $employee;
        return view('admin.employee.employeeinfo.employeeinfoshort',compact('employee','function'));
    }

    public function appemployinfopdf($id)
    {
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            ['employee_personal_info','employee_present_address','employee_permanent_address','employee_language','employeequalification'=>function($q){ $q->orderBy('passing_year','asc'); },
            'employee_local_training','employee_foreign_training','employee_travel','employee_posingabroad','employee_professionalqualification',
            'employee_publication','employee_hounourrewards','employee_otherservice','employee_service','employee_family_info','employee_bank_info',
            'employee_first_joining','employee_present_position','employee_promotion_higher_scale','pay_allowance_deduction','employee_gpf',
            'employee_gpf_advance','employee_loan','employee_leave_lien','employee_desciplinary_action','employee_pension_nominee','employee_gpf_nominee'
            ,'employee_accommodation','employee_authorized_leave']
        )->findorfail($id);

        $present_position_present_class = $this->function->present_position_present_class();
        $gender = $this->function->gender();
        $religion = $this->function->religion();
        $marital_status = $this->function->marital_status();
        $type_of_entry_of_govt_service = $this->function->type_of_entry_of_govt_service();
        $nature_of_provident_fund = $this->function->nature_of_provident_fund();

        $function = $this->function;

        // return $employee;
        return view('appEmployeeInfo',compact('employee','function','marital_status',
        'religion','gender','nature_of_provident_fund','type_of_entry_of_govt_service','present_position_present_class'));
    }


public function find_relation(Request $request){
    if(isset($request->data) && (int)$request->data > 0){
        $function = $this->function;
        if((int)$request->gpf == 1){
            $familyinfo = Employee_family_info::find((int)$request->data);
            return view('admin.employee.extra_partial_page.gpf_nomine',compact('familyinfo','function'));
        }
        if((int)$request->nom == 1){
            $familyinfo = Employee_family_info::find((int)$request->data);
            return view('admin.employee.extra_partial_page.nomineepension',compact('familyinfo','function'));
        }
    }
}














}
