<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;

use App\Http\Controllers\FunctionController;
use App\Models\Employee;
use App\Models\Employee_family_info;
use App\Models\Employee_gpf;
use App\Models\Employee_gpf_advance;
use App\Models\Employee_gpf_nominee;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class GPFController extends Controller
{
    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }
    public function index($id){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            'employee_gpf',
            'employee_gpf_nominee','employee_family_info',
            'employee_gpf_advance'
        )->findorfail($id);
        $function = $this->function;
        return view('admin.employee.gpf',compact('employee','loggedin','function'));
    }
    public function db($id,Request $request){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            'employee_gpf',
            'employee_gpf_nominee',
            'employee_gpf_advance'
        )->findorfail($id);
        if(isset($employee->id)){
            if(isset($employee->employee_gpf->id)){
                $employee_gpf = Employee_gpf::find($employee->employee_gpf->id);
            }else{
                $new = 1;
                $employee_gpf = new Employee_gpf();
                $employee_gpf->employee_id = $employee->id;
            }
            if(isset($request->gpf_nopf) && (int)$request->gpf_nopf > 0){
                $employee_gpf->nature = (int)$request->gpf_nopf;
            }
            if(isset($request->gpf_account_number)){
                $employee_gpf->account_number = $request->gpf_account_number;
            }
            if(isset($request->gpf_volume_number)){
                $employee_gpf->volume_number = $request->gpf_volume_number;
            }
            if(isset($request->gpf_lpn)){
                $employee_gpf->latest_page = $request->gpf_lpn;
            }
            if(isset($request->gpf_msdap)){
                $employee_gpf->subscription = $request->gpf_msdap;
            }
            if(!isset(Auth::user()->employee_id)){
                $keys = array_keys($employee_gpf->getOriginal());
                foreach ($keys as $dkey) {
                    $key2 = str_replace('_',' ',$dkey);
                    if($dkey != 'created_at' || $dkey != 'updated_at') {
                        if (isset($new) && $new == 1) {
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'GPF ' . $key2,
                                'old' => '',
                                'new' => $employee_gpf[$dkey],
                                'record_type' => 1,
                            ]);
                        } elseif ($employee_gpf->isDirty($dkey)) {
                            $employee->record_changelog()->create([
                                'employee_id' => $employee->id,
                                'user_id' => Auth::id(),
                                'name' => 'GPF ' . $key2,
                                'old' => $employee_gpf->getOriginal($dkey),
                                'new' => $employee_gpf[$dkey],
                                'record_type' => 2,
                            ]);

                        }
                    }
                }
            }
            $employee_gpf->save();
            //nominee
            if(isset($request->gpf_nomine) && count($request->gpf_nomine) > 0){
                foreach ($request->gpf_nomine as $key=>$gpf_nomine){
                    if(count(explode('x',$key)) > 1){
                        $ea = new Employee_gpf_nominee();
                        $ea->employee_id = $employee->id;
                    }else{
                        $key = (int)$key;
                        $ea = Employee_gpf_nominee::find($key);
                    }
                    if(isset($gpf_nomine['nid'])){$ea->nid_or_birth_certificate = $gpf_nomine['nid'];}
                    if(isset($gpf_nomine['dob'])){$ea->birth_date = Carbon::parse($gpf_nomine['dob'])->format('Y-m-d');}
                    if(isset($gpf_nomine['relation'])){$ea->relation = $gpf_nomine['relation'];}
                    if(isset($gpf_nomine['name'])){$ea->name = $gpf_nomine['name'];}
                    if(isset($gpf_nomine['name_en'])){$ea->name_en = $gpf_nomine['name_en'];}
                    if(isset($gpf_nomine['percent'])){$ea->designated_part_percent = $gpf_nomine['percent'];}
                    if(!isset(Auth::user()->employee_id)){
                        $keys = array_keys($ea->getOriginal());
                        foreach ($keys as $dkey) {
                            $key2 = str_replace('_',' ',$dkey);
                            if($dkey != 'created_at' || $dkey != 'updated_at') {
                                if (count(explode('x', $key)) > 1) {
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => 'GPF Nominee ' . $key2,
                                        'old' => '',
                                        'new' => $ea[$dkey],
                                        'record_type' => 1,
                                    ]);
                                } elseif ($ea->isDirty($dkey)) {
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => 'GPF Nominee ' . $key2,
                                        'old' => $ea->getOriginal($dkey),
                                        'new' => $ea[$dkey],
                                        'record_type' => 2,
                                    ]);
                                }
                            }
                        }
                    }
                    $ea->save();
                }
            }
            if(isset($request->gpf_advance) && count($request->gpf_advance) > 0){
                foreach ($request->gpf_advance as $key=>$gpf_advance){
                    if(count(explode('x',$key)) > 1){
                        $gpf = new Employee_gpf_advance();
                        $gpf->employee_id = $employee->id;
                    }else{
                        $gpf = Employee_gpf_advance::find((int)$key);
                    }
                    $gpf->sanction_number = (int)$gpf_advance['sanction_number'];
                    $gpf->sanction_date = Carbon::parse($gpf_advance['sanction_date'])->format("Y-m-d");
                    if(isset($gpf_advance['sanction_installment_starting_date'])){$gpf->sanction_installment_starting_date = Carbon::parse($gpf_advance['sanction_installment_starting_date'])->format("Y-m-d");}
                    if(isset($gpf_advance['sanction_amount'])){$gpf->sanction_amount = $gpf_advance['sanction_amount'];}
                    if(isset($gpf_advance['sanction_total_no_installment'])){$gpf->sanction_total_no_installment = $gpf_advance['sanction_total_no_installment'];}
                    if(isset($gpf_advance['sanction_no_installment_paid'])){$gpf->sanction_no_installment_paid = $gpf_advance['sanction_no_installment_paid'];}
                    if(isset($gpf_advance['sanction_total_interest_amount'])){$gpf->sanction_total_interest_amount = $gpf_advance['sanction_total_interest_amount'];}
                    if(isset($gpf_advance['sanction_adjusted_amount'])){$gpf->sanction_adjusted_amount = $gpf_advance['sanction_adjusted_amount'];}
                    if(isset($gpf_advance['sanction_number_interest_installment'])){$gpf->sanction_number_interest_installment = $gpf_advance['sanction_number_interest_installment'];}
                    if(isset($gpf_advance['sanction_number_interest_installment_paid'])){$gpf->sanction_number_interest_installment_paid = $gpf_advance['sanction_number_interest_installment_paid'];}
                    if(!isset(Auth::user()->employee_id)){
                        $keys = array_keys($gpf->getOriginal());
                        foreach ($keys as $dkey) {
                            $key2 = str_replace('_',' ',$dkey);
                            if($dkey != 'created_at' || $dkey != 'updated_at'){
                                if (count(explode('x', $key)) > 1) {
                                    if(isset($gpf[$dkey])){
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'GPF Advance : ' . $key2,
                                            'old' => '',
                                            'new' => $gpf[$dkey],
                                            'record_type' => 1,
                                        ]);
                                    }
                                } elseif ($gpf->isDirty($dkey)) {
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => 'GPF Advance : '.$key2,
                                        'old' => $gpf->getOriginal($dkey),
                                        'new' => $gpf[$dkey],
                                        'record_type' => 2,
                                    ]);
                                }
                            }
                        }
                    }
                    $gpf->save();
                }
            }

            if(isset($request->remove)){
                $arr = explode(',',$request->remove);
                foreach ($arr as $arrv){
                    $data = explode('_',$arrv);
                    if(count($data) > 0){
                        if($data[0]=='gn'){
                            $promotion = Employee_gpf_nominee::find((int)$data[1]);
                            if(isset($promotion->id)){
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => 'Employee GPF Nominee deleted',
                                    'old' => 'Nid or Birth Certificate : '.$promotion->nid_or_birth_certificate.'\n'.
                                        'Birth Date : '.$promotion->birth_date.'\n'.
                                        'Relation : '.$promotion->relation.'\n'.
                                        'Nominee Name :'.$promotion->name.'\n'.
                                        'Designated part percent : '.$promotion->designated_part_percent.'\n'
                                    ,
                                    'new' => '',
                                    'record_type' => 3,
                                ]);
                                $promotion->delete();
                            }
                        }
                        if($data[0]=='gpfad'){
                            $promotion = Employee_gpf_advance::find((int)$data[1]);
                            if(isset($promotion->id)){
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => 'Employee GPF Advance deleted',
                                    'old' => 'Sanction number : '.$promotion->sanction_number.'\n'.
                                        'Sanction date : '.$promotion->sanction_date.'\n'.
                                        'Sanction installment starting date : '.$promotion->sanction_installment_starting_date.'\n'.
                                        'Sanction amount :'.$promotion->sanction_amount.'\n'.
                                        'Sanction total no installment : '.$promotion->sanction_total_no_installment.'\n'.
                                        'Sanction no installment paid : '.$promotion->sanction_no_installment_paid.'\n'.
                                        'Sanction total interest amount : '.$promotion->sanction_total_interest_amount.'\n'.
                                        'Sanction adjusted amount : '.$promotion->sanction_adjusted_amount.'\n'.
                                        'Sanction number interest installment : '.$promotion->sanction_number_interest_installment.'\n'.
                                        'Sanction number interest installment paid : '.$promotion->sanction_number_interest_installment_paid.'\n'
                                    ,
                                    'new' => '',
                                    'record_type' => 3,
                                ]);
                                $promotion->delete();
                            }
                        }
                    }
                }
            }
        }

        return redirect()->back()->with('type','success')->with('message','Updated Successfully');
    }


    public function gpf_nomine(){
        $function = $this->function;
        return view('admin.employee.extra_partial_page.gpf_nomine',compact('function'));
    }
    public function gpf_adv(){
        return view('admin.employee.extra_partial_page.gpf_advance');
    }
}
