<?php

namespace App\Http\Controllers\Employee;
use App\Http\Controllers\Controller;
use App\Models\Employee;
use App\Models\EmployeeRestRecreation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EmployeeOtherController extends Controller
{
    public function all_logs($id){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(['record_changelog' => function ($query) {
            $query->orderBy('id','desc');
            $query->with('user');
        }])->findorfail($id);
        return view('admin.employee.log',compact('employee','loggedin'));
    }
}
