<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;

use App\Http\Controllers\FunctionController;
use App\Models\Employee;
use App\Models\Employee_loan;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EmployeeLoanController extends Controller
{
    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }
    public function index($id){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            'employee_loan'
        )->findorfail($id);
        $function = $this->function;
        return view('admin.employee.loan',compact('employee','loggedin','function'));
    }
    public function db($id,Request $request)    {
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::findorfail($id);
        if (isset($employee->id)) {
            if(isset($request->loan) && count($request->loan) > 0){
                foreach ($request->loan as $key=>$req_loan){
                    if(count(explode('x',$key)) > 1){
                        $loan = new Employee_loan();
                        $loan->employee_id = $employee->id;
                    }else{
                        $loan = Employee_loan::find((int)$key);
                    }
                    $loan->name = $req_loan['name'];
                    $loan->sanction_number = (int)$req_loan['sanction_number'];
                    $loan->sanction_date = Carbon::parse($req_loan['sanction_date'])->format("Y-m-d");
                    if(isset($req_loan['sanction_installment_starting_date'])){$loan->sanction_installment_starting_date = Carbon::parse($req_loan['sanction_installment_starting_date'])->format("Y-m-d");}
                    if(isset($req_loan['sanction_amount'])){$loan->sanction_amount = $req_loan['sanction_amount'];}
                    if(isset($req_loan['depreciation_amount'])){$loan->depreciation_amount = $req_loan['depreciation_amount'];}
                    if(isset($req_loan['sanction_total_no_installment'])){$loan->sanction_total_no_installment = $req_loan['sanction_total_no_installment'];}
                    if(isset($req_loan['sanction_no_installment_paid'])){$loan->sanction_no_installment_paid = $req_loan['sanction_no_installment_paid'];}
                    if(isset($req_loan['sanction_total_interest_amount'])){$loan->sanction_total_interest_amount = $req_loan['sanction_total_interest_amount'];}
                    if(isset($req_loan['sanction_adjusted_amount'])){$loan->sanction_adjusted_amount = $req_loan['sanction_adjusted_amount'];}
                    if(isset($req_loan['sanction_number_interest_installment'])){$loan->sanction_number_interest_installment = $req_loan['sanction_number_interest_installment'];}
                    if(isset($req_loan['sanction_number_interest_installment_paid'])){$loan->sanction_number_interest_installment_paid = $req_loan['sanction_number_interest_installment_paid'];}
                    if(!isset(Auth::user()->employee_id)){
                        $keys = array_keys($loan->getOriginal());
                        foreach ($keys as $dkey) {
                            $key2 = str_replace('_',' ',$dkey);
                            if($dkey != 'created_at' || $dkey != 'updated_at'){
                                if (count(explode('x', $key)) > 1) {
                                    if(isset($loan[$dkey])){
                                        $employee->record_changelog()->create([
                                            'employee_id' => $employee->id,
                                            'user_id' => Auth::id(),
                                            'name' => 'Loan : ' . $key2,
                                            'old' => '',
                                            'new' => $loan[$dkey],
                                            'record_type' => 1,
                                        ]);
                                    }
                                } elseif ($loan->isDirty($dkey)) {
                                    $employee->record_changelog()->create([
                                        'employee_id' => $employee->id,
                                        'user_id' => Auth::id(),
                                        'name' => 'Loan : '.$key2,
                                        'old' => $loan->getOriginal($dkey),
                                        'new' => $loan[$dkey],
                                        'record_type' => 2,
                                    ]);
                                }
                            }
                        }
                    }
                    $loan->save();
                }
            }
            if(isset($request->remove)){
                $arr = explode(',',$request->remove);
                foreach ($arr as $arrv){
                    $data = explode('_',$arrv);
                    if(count($data) > 0){
                        if($data[0]=='loan'){
                            $loan_del = Employee_loan::find((int)$data[1]);
                            if(isset($loan_del->id)){
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => 'Loan :'.$loan_del->name.' deleted',
                                    'old' => 'Sanction number : '.$loan_del->sanction_number.'\n'.
                                        'Sanction date : '.$loan_del->sanction_date.'\n'.
                                        'Sanction installment starting date : '.$loan_del->sanction_installment_starting_date.'\n'.
                                        'Sanction amount :'.$loan_del->sanction_amount.'\n'.
                                        'Depreciation amount :'.$loan_del->depreciation_amount.'\n'.
                                        'Sanction total no installment : '.$loan_del->sanction_total_no_installment.'\n'.
                                        'Sanction no installment paid : '.$loan_del->sanction_no_installment_paid.'\n'.
                                        'Sanction total interest amount : '.$loan_del->sanction_total_interest_amount.'\n'.
                                        'Sanction adjusted amount : '.$loan_del->sanction_adjusted_amount.'\n'.
                                        'Sanction number interest installment : '.$loan_del->sanction_number_interest_installment.'\n'.
                                        'Sanction number interest installment paid : '.$loan_del->sanction_number_interest_installment_paid.'\n'
                                    ,
                                    'new' => '',
                                    'record_type' => 3,
                                ]);
                                $loan_del->delete();
                            }
                        }
                    }
                }
            }
        }
        return redirect()->back()->with('type','success')->with('message','Updated Successfully');
    }
    public function loan_add(){
        $function = $this->function;
        return view('admin.employee.extra_partial_page.loan_table',compact('function'));
    }
}
