<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;
use App\Http\Controllers\FunctionController;
use App\Http\Controllers\LeaveManagementController;
use App\Models\Employee;
use App\Models\Employee_family_info;
use App\Models\Employee_present_postion;
use App\Models\EmployeeTransfer;
use App\Models\LeaveType;
use App\Models\User;
use Aqualink\District\Models\Quota;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Hash;
use League\Flysystem\Config;

class EmployeeController extends Controller
{
    /**
     * @var array
     */
    private $employee_id;
    /**
     * @var FunctionController
     */
    private $function;

    public function __construct(FunctionController $functionController,LeaveManagementController $leaveManagementController)
    {
        $this->function = $functionController;
        $this->leave_controller = $leaveManagementController;
    }
    public function index(){
        $employees = Cache::remember('employee', 60*60, function() {
            return Employee::with('employee_personal_info',
                'employee_present_position',
                'employee_first_joining')->get();
        });
        $function = $this->function;
        return view("admin.employee.index",compact('employees','function'));
    }
    public function addnew(){
        $function = $this->function;
        return view("admin.employee.addnew.index",compact('function'));
    }
    public function edit($id){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::findorfail($id);
        $function = $this->function;
        return view("admin.employee.addnew.index",compact('employee','loggedin','function'));
    }
    public function delete($id){
        $employee = Employee::with(
            'employee_personal_info','employee_present_address','employee_permanent_address','employee_language','employeequalification',
            'employee_local_training','employee_foreign_training','employee_travel','employee_posingabroad','employee_professionalqualification',
            'employee_publication','employee_hounourrewards','employee_otherservice','employee_service','user'
        )->findorfail($id);
        $employee->delete();
        return redirect()->route('manage_employee.index')->with('type','success')->with('message','Deleted successfully');
    }
    public function addnew_db(Request $request){
        // return $request;
        $url = "http://66.45.237.70/api.php";
        $loggedin = Auth::user();
        if(!isset($loggedin->employee_id)){
            $validatedData = $request->validate([
                'name_bn' => ['required','string'],
                'rank' => ['required','string'],
                'dob' => ['required','date'],
                'type_of_entry' => ['required'],
                
            ]);
        }

        if(isset($request->other)){
            if(!isset($loggedin->employee_id)) {
                $validatedData = $request->validate([
                    'nid' => ['required', 'numeric'],
                    
                ]);
            }
            if(isset($loggedin->employee_id)){$request->other = $loggedin->employee_id;}
            $employee =Employee::find($request->other);
            $cuser = User::where('employee_id',$employee->id)->first();
            if(isset($request->name_bn)){$cuser->name = $request->name_bn;}

            if(isset($request->email)){
                $check_email = User::where('email',$request->email)->first();
                if (!empty($check_email)) {
                    if ($cuser->id != $check_email->id) {
                    
                        return redirect()->back()->with('type','danger')->with('message','email already taken');
                    }
                    
                }
                $cuser->email = $request->email;
                if($employee->isDirty('email')) {
                    // $validatedData = $request->validate([
                      
                    //     'email' => ['required','unique:users'],
                    // ]);
                    $employee->record_changelog()->create([
                        'employee_id' => $employee->id,
                        'user_id' => Auth::id(),
                        'name' => 'email',
                        'old' => $cuser->getOriginal('email'),
                        'new' => $cuser['email'],
                        'record_type' => 2,
                    ]);

                    $number= $cuser->contact;
                    $text= "Land Port Authority PIMS: Your email has been changed to : ".$request->email;
                    $this->function->sendsms($number,$text);
                }
            }
            if(isset($request->password)) {
                $cuser->password = Hash::make($request->password);
                if ($employee->isDirty('password')) {
                    $employee->record_changelog()->create([
                        'employee_id' => $employee->id,
                        'user_id' => Auth::id(),
                        'name' => 'password',
                        'old' => '*****',
                        'new' => '********',
                        'record_type' => 2,
                    ]);
                    $number= $cuser->contact;
                    $text= "Land Port Authority PIMS: Your password has been changed to : ".$request->password;
                    $this->function->sendsms($number,$text);
                }
            }
            if(isset($request->rank)){$cuser->rank = $request->rank;}
            if(isset($request->sms_number)){$cuser->contact = $request->sms_number;}
            $cuser->save();
        }else{
            $validatedData = $request->validate([
                'nid' => ['required', 'unique:employees', 'numeric'],
            ]);
            $employee = new Employee();
        }
        if(isset($request->nid)){$employee ->nid = $request->nid;}
        if(isset($request->name_bn)){$employee->name = $request->name_bn;}
        if(isset($request->name_eng)){$employee->name_eng = $request->name_eng;}
        if(isset($request->rank)){$employee->rank = $request->rank;}
        if(isset($request->dob)){$employee->dob = Carbon::parse($request->dob)->format("Y-m-d");}
        if(isset($request->type_of_entry)){$employee->toegs = (int)$request->type_of_entry;}
        if(isset($request->sms_number)){$employee->sms_number = $request->sms_number;}
        if(isset($request->quota)){
            $employee->quota = $request->quota;
            $quota=Quota::find((int)$request->quota);
            if(isset($quota->id)){
                $employee->prl_date = Carbon::parse($request->dob)->modify('+'.$quota->max_age.' year')->format("Y-m-d");
            }
        }
        $type_of_entry = $this->function->type_of_entry_of_govt_service();
        if(isset($request->other) && $employee->isDirty()){
            $keys = array_keys($employee->getOriginal());
            foreach ($keys as $key){
                if($employee->isDirty($key)){
                    if($key == 'nid'){$key2 = 'National ID card';}
                    if($key == 'name'){$key2 = 'Name';}
                    if($key == 'rank'){$key2 = 'Rank';}
                    if($key == 'dob'){$key2 = 'Dath of Birth';}
                    if($key == 'toegs'){$key2 = 'Type of Entry';}
                    if($key == 'quota'){$key2 = 'Quota';}
                    if($key == 'prl_date'){$key2 = 'PRL Date';}
//                    if($key == 'email'){$key2 = 'Email';}
                    if($key == 'sms_number'){$key2 = 'SMS Notification Number';
                        $number= $employee->getOriginal($key);
                        $text= "Land Port Authority PIMS: Your contact number has been changed to ".$employee[$key];
                        $this->function->sendsms($number,$text);
                        $number= $employee[$key];
                        $text= "Land Port Authority PIMS: Congratulation. Your contact number has been updated.";
                        $this->function->sendsms($number,$text);
                    }
//                    if($key == 'password'){
//                        $employee->record_changelog()->create([
//                            'employee_id'=> $employee->id,
//                            'user_id'=> Auth::id(),
//                            'name'=> $key2,
//                            'old'=> '*****',
//                            'new'=> '********',
//                        ]);
//                    }else
                    if($key == 'toegs'){
                        if($employee->getOriginal($key) > 0){
                            $employee->record_changelog()->create([
                                'employee_id'=> $employee->id,
                                'user_id'=> Auth::id(),
                                'name'=> $key2,
                                'old'=> $type_of_entry[$employee->getOriginal($key)][0].'('.$type_of_entry[$employee->getOriginal($key)][1].')',
                                'new'=> $type_of_entry[$employee[$key]][0],
                                'record_type' => 2,
                            ]);
                        }
                    }elseif($key == 'rank'){
                        if((int)$employee->getOriginal($key) > 0){
                            $employee->record_changelog()->create([
                                'employee_id'=> $employee->id,
                                'user_id'=> Auth::id(),
                                'name'=> $key2,
                                'old'=> $this->function->rank()[(int)$employee->getOriginal($key)]['name_en'].'('.$this->function->rank()[(int)$employee->getOriginal($key)]['name_bn'].')',
                                'new'=> $this->function->rank()[(int)$employee[$key]]['name_en'].'('.$this->function->rank()[(int)$employee[$key]]['name_bn'].')',
                                'record_type' => 2,
                            ]);
                        }
                    }elseif($key == 'quota'){
                        if((int)$employee->getOriginal($key) > 0){
                            $employee->record_changelog()->create([
                                'employee_id'=> $employee->id,
                                'user_id'=> Auth::id(),
                                'name'=> $key2,
                                'old'=> $this->function->qoutas()[(int)$employee->getOriginal($key)]['name_en'].'('.$this->function->qoutas()[(int)$employee->getOriginal($key)]['name_bn'].')',
                                'new'=> $this->function->qoutas()[(int)$employee[$key]]['name_en'].'('.$this->function->qoutas()[(int)$employee[$key]]['name_bn'].')',
                                'record_type' => 2,
                            ]);
                        }
                    }
                    else{
                        $employee->record_changelog()->create([
                            'employee_id'=> $employee->id,
                            'user_id'=> Auth::id(),
                            'name'=> $key2,
                            'old'=> $employee->getOriginal($key),
                            'new'=> $employee[$key],
                            'record_type' => 2,
                        ]);
                    }
                }
            }

        }
        $employee->save();
        if( ! isset($request->other)){
            $cuser = new User();
            $cuser->employee_id = $employee->id;
            if(isset($request->name_bn)){$cuser->name = $request->name_bn;}

            if(isset($request->email)){$cuser->email = $request->email;}
            if(isset($request->password)){$cuser->password = Hash::make($request->password);}
            if(isset($request->rank)){$cuser->rank = $request->rank;}
            if(isset($request->sms_number)){$cuser->contact = $request->sms_number;}
            $cuser->save();
            $number= $cuser->contact;
            $text= "Land Port Authority PIMS: Congratulation. your account has been created.\n email: ".$request->email."\n password: ".$request->password."\n url: ".env('APP_URL');
            $this->function->sendsms($number,$text);

            $leaves = LeaveType::all();
            foreach ($leaves as $leave){
                $this->leave_controller->leavestatusupdate($employee->id,$leave->id,0);
            }
        }



        return redirect()->route('employee.index',['id'=>$employee->id,'l'=>2])->with('type','success')->with('message','saved successfully');
    }
    public function employee_list(Request $request){
        $this->employee_id = Cache::remember('allemployeeid', 15*60, function() { return Employee::all()->pluck('id')->toArray(); });
//        $allemployee =  $employees = Employee::with(
//            'employee_normal_child',
//            'employee_autistic_child'
//            )->get();

        $working_place = $this->employee_id;
        if(isset($request->working_place) && (int)$request->working_place > 0){
            $working_place = Employee_present_postion::where('working_place',$request->working_place)->pluck('employee_id')->toArray();
        }
        $transfer = $this->employee_id;
        if(isset($request->transfer) && (int)$request->transfer > 0){
            $transfer = EmployeeTransfer::where('start_date','<=',Carbon::today())->where('end_date','>=',Carbon::today())->where('working_place','LIKE',$request->transfer)->pluck('employee_id')->toArray();
        }
        $grade = $this->employee_id;
        if(isset($request->grade) && (int)$request->grade > 0){
            $grade = Employee_present_postion::where('grade','LIKE',$request->grade)->pluck('employee_id')->toArray();
        }
        $scale = $this->employee_id;
        if(isset($request->scale) && (int)$request->scale > 0){
            $scale = Employee_present_postion::where('scale','LIKE',$request->scale)->pluck('employee_id')->toArray();
        }
        if(isset($request->rank) && (int)$request->rank > 0){
            $employees = Employee::with('employee_personal_info',
                'employee_present_position',
                'employee_first_joining',
                'employee_promotion_higher_scale',
                'employee_loan',
                'employee_desciplinary_action')
                ->where('rank','LIKE',$request->rank)
                ->whereIn('id',$transfer)
                ->whereIn('id',$working_place)
                ->whereIn('id',$grade)
                ->whereIn('id',$scale)
                ->get();
        }else{
            $employees = Employee::with('employee_personal_info',
                'employee_present_position',
                'employee_first_joining',
                'employee_promotion_higher_scale',
                'employee_loan',
                'employee_desciplinary_action')
                ->whereIn('id',$transfer)
                ->whereIn('id',$working_place)
                ->whereIn('id',$grade)
                ->whereIn('id',$scale)
                ->get();
        }
//        dd($employees,$age,$child,$post,$grade,$scale);
        $function = $this->function;
        return view('admin.employee.table.index',compact('employees','function'));

    }

    public function sendupdatetoall(){
        $employees = Employee::with('user')->get();
        foreach ($employees as $employee){
            $text= "Land Port Authority PIMS: Web application updated. Please check and update your information.";
            $this->function->sendsms($employee->sms_number,$text);
        }
    }


}
