<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;

use App\Http\Controllers\FunctionController;
use App\Models\Employee;
use App\Models\Employee_desciplinary_action;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DeciplinaryActionController extends Controller
{
    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }
    public function index($id){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            'employee_desciplinary_action'
        )->findorfail($id);
        $function = $this->function;
        return view('admin.employee.disciplinary',compact('employee','loggedin','function'));
    }
    public function db($id,Request $request)
    {
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::findorfail($id);
        if (isset($employee->id)) {

            if(isset($request->penalty) && count($request->penalty) > 0){
                foreach ($request->penalty as $key=>$penalty){
                    if(!isset($penalty['nature']) && !isset($penalty['type'])){
                        return redirect()->back()->with('type','danger')->with('message','Nature and type must not empty');
                    }
                    if(count(explode('x',$key)) > 1){
                        $ea = new Employee_desciplinary_action();
                        $ea->employee_id = $employee->id;
                    }else{
                        $key = (int)$key;
                        $ea = Employee_desciplinary_action::find($key);
                    }
                    if(isset($penalty['nature'])){$ea->nature_of_penalty = (int)$penalty['nature'];}
                    if(isset($penalty['type'])){$ea->type_of_penalty = (int)$penalty['type'];}
                    if(isset($penalty['pn'])){$ea->order_number = $penalty['pn'];}
                    if(isset($penalty['pd'])){$ea->order_date = Carbon::parse($penalty['pd'])->format('Y-m-d');}
                    if(isset($penalty['sd'])){$ea->start_date = Carbon::parse($penalty['sd'])->format('Y-m-d');}
                    if(isset($penalty['ed'])){$ea->end_date = Carbon::parse($penalty['ed'])->format('Y-m-d');}
                    if(isset($penalty['rads'])){$ea->requested_salary = $penalty['rads'];}
                    if(isset($penalty['comment'])){$ea->comment = $penalty['comment'];}
                    if(!isset(Auth::user()->employee_id)){
                        $keys = array_keys($ea->getOriginal());
                        foreach ($keys as $dkey) {
                            $key2 = str_replace('_',' ',$dkey);
                            if (count(explode('x', $key)) > 1) {
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => $key2,
                                    'old' => '',
                                    'new' => $ea[$dkey],
                                    'record_type' => 1,
                                ]);
                            } elseif ($ea->isDirty($dkey)) {
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => $key2,
                                    'old' => $ea->getOriginal($dkey),
                                    'new' => $ea[$dkey],
                                    'record_type' => 2,
                                ]);
                            }
                        }
                    }


                    $ea->save();
                }
            }

            if(isset($request->remove)){
                $arr = explode(',',$request->remove);
                foreach ($arr as $arrv){
                    $data = explode('_',$arrv);
                    if(count($data) > 1){
                        if($data[0]=='pn'){
                            $promotion = Employee_desciplinary_action::find((int)$data[1]);
                            if(isset($promotion->id)){
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => 'Employee desciplinary action deleted',
                                    'old' => 'nature of penalty : '.$promotion->nature_of_penalty.'\n'.
                                        'type of penalty : '.$promotion->type_of_penalty.'\n'.
                                        'order number : '.$promotion->order_number.'\n'.
                                        'order date :'.$promotion->order_date.'\n'.
                                        'start date : '.$promotion->start_date.'\n'.
                                        'end date : '.$promotion->end_date.'\n'.
                                        'requested salary : '.$promotion->requested_salary.'\n'.
                                        'comment : '.$promotion->comment.'\n'
                                    ,
                                    'new' => '',
                                    'record_type' => 3,
                                ]);
                                $promotion->delete();
                            }

                        }
                    }
                }
            }
        }
        return redirect()->back()->with('type','success')->with('message','Updated Successfully');
    }


    public function disciplinary(){
        $function = $this->function;
        return view('admin.employee.extra_partial_page.disciplinary',compact('function'));
    }
}
