<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;

use App\Http\Controllers\FunctionController;
use App\Models\Employee;
use App\Models\Employee_accommodation;
use App\Models\Employee_authorized_leave;
use App\Models\Employee_gpf_nominee;
use App\Models\Employee_leave_lien;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthorizedLeaveController extends Controller
{
    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }
    public function index($id){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::with(
            'employee_authorized_leave',
            'employee_leave_lien'
        )->findorfail($id);
        $function = $this->function;
        return view('admin.employee.earned_leave',compact('employee','loggedin','function'));
    }
    public function db($id,Request $request){
        $loggedin = Auth::user();
        if(isset($loggedin->employee_id)){$id = $loggedin->employee_id;}
        $employee = Employee::findorfail($id);
        if (isset($employee->id)) {
            if(isset($request->earned_leave) && count($request->earned_leave) > 0){
                foreach ($request->earned_leave as $key=>$earned_leave){
                    if(count(explode('x',$key)) > 1){
                        $ea = new Employee_authorized_leave();
                        $ea->employee_id = $employee->id;
                    }else{
                        $key = (int)$key;
                        $ea = Employee_authorized_leave::find($key);
                    }
                    if(isset($earned_leave['type'])){$ea->type_of_leave = $earned_leave['type'];}
                    if(isset($earned_leave['nop'])){$ea->nature_to_pay = $earned_leave['nop'];}
                    if(isset($earned_leave['rfl'])){$ea->reason = $earned_leave['rfl'];}
                    if(isset($earned_leave['sanction'])){$ea->sanction = $earned_leave['sanction'];}
                    if(isset($earned_leave['sanction_date'])){$ea->sanction_date = Carbon::parse($earned_leave['sanction_date'])->format('Y-m-d');}
                    if(isset($earned_leave['polasd'])){$ea->start_date = Carbon::parse($earned_leave['polasd'])->format('Y-m-d');}
                    if(isset($earned_leave['polaed'])){$ea->end_date = Carbon::parse($earned_leave['polaed'])->format('Y-m-d');}
                    if(isset($earned_leave['tla'])){$ea->total_leave_availed = $earned_leave['tla'];}
                    if(!isset(Auth::user()->employee_id)){
                        $keys = array_keys($ea->getOriginal());
                        foreach ($keys as $dkey) {
                            $key2 = str_replace('_',' ',$dkey);
                            if (count(explode('x', $key)) > 1) {
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => $key2,
                                    'old' => '',
                                    'new' => $ea[$dkey],
                                    'record_type' => 1,
                                ]);
                            } elseif ($ea->isDirty($dkey)) {
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => $key2,
                                    'old' => $ea->getOriginal($dkey),
                                    'new' => $ea[$dkey],
                                    'record_type' => 2,
                                ]);
                            }
                        }
                    }
                    $ea->save();
                }
            }
            if(isset($request->lien) && count($request->lien) > 0){
                foreach ($request->lien as $key=>$lien){
                    if(count(explode('x',$key)) > 1){
                        $ea = new Employee_leave_lien();
                        $ea->employee_id = $employee->id;
                    }else{
                        $key = (int)$key;
                        $ea = Employee_leave_lien::find($key);
                    }
                    if(isset($lien['organization'])){$ea->organization = $lien['organization'];}
                    if(isset($lien['sanction'])){$ea->sanction = $lien['sanction'];}
                    if(isset($lien['sanction_date'])){$ea->sanction_date = Carbon::parse($lien['sanction_date'])->format('Y-m-d');}
                    if(isset($lien['tpsd'])){$ea->start_date = Carbon::parse($lien['tpsd'])->format('Y-m-d');}
                    if(isset($lien['tpfd'])){$ea->end_date = Carbon::parse($lien['tpfd'])->format('Y-m-d');}
                    if(isset($lien['ttp'])){$ea->total_period = $lien['ttp'];}
                    if(isset($lien['lsc'])){$ea->leave_salary_contribution = $lien['lsc'];}
                    if(!isset(Auth::user()->employee_id)){
                        $keys = array_keys($ea->getOriginal());
                        foreach ($keys as $dkey) {
                            $key2 = str_replace('_',' ',$dkey);
                            if (count(explode('x', $key)) > 1) {
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => $key2,
                                    'old' => '',
                                    'new' => $ea[$dkey],
                                    'record_type' => 1,
                                ]);
                            } elseif ($ea->isDirty($dkey)) {
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => $key2,
                                    'old' => $ea->getOriginal($dkey),
                                    'new' => $ea[$dkey],
                                    'record_type' => 2,
                                ]);
                            }
                        }
                    }
                    $ea->save();
                }
            }

            if(isset($request->remove)){
                $arr = explode(',',$request->remove);
                foreach ($arr as $arrv){
                    $data = explode('_',$arrv);
                    if(count($data) > 0){
                        if($data[0]=='al'){
                            $promotion = Employee_authorized_leave::find((int)$data[1]);
                            if(isset($promotion->id)){
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => 'Employee authorized leave',
                                    'old' => 'type of leave : '.$promotion->type_of_leave.'\n'.
                                        'nature to pay : '.$promotion->nature_to_pay.'\n'.
                                        'reason : '.$promotion->reason.'\n'.
                                        'sanction :'.$promotion->sanction.'\n'.
                                        'sanction date :'.$promotion->sanction_date.'\n'.
                                        'start date : '.$promotion->start_date.'\n'.
                                        'end date : '.$promotion->end_date.'\n'.
                                        'total leave availed : '.$promotion->total_leave_availed.'\n'
                                    ,
                                    'new' => '',
                                    'record_type' => 3,
                                ]);
                                $promotion->delete();
                            }
                        }
                        if($data[0]=='lien'){
                            $promotion = Employee_leave_lien::find((int)$data[1]);
                            if(isset($promotion->id)){
                                $employee->record_changelog()->create([
                                    'employee_id' => $employee->id,
                                    'user_id' => Auth::id(),
                                    'name' => 'Employee authorized leave',
                                    'old' => 'organization : '.$promotion->organization.'\n'.
                                        'sanction :'.$promotion->sanction.'\n'.
                                        'sanction date :'.$promotion->sanction_date.'\n'.
                                        'start date : '.$promotion->start_date.'\n'.
                                        'end date : '.$promotion->end_date.'\n'.
                                        'total period : '.$promotion->total_period.'\n'.
                                        'leave salary contribution : '.$promotion->leave_salary_contribution.'\n'
                                    ,
                                    'new' => '',
                                    'record_type' => 3,
                                ]);
                                $promotion->delete();
                            }
                        }
                    }
                }
            }

            return redirect()->back()->with('type','success')->with('message','Updated Successfully');
        }
    }


    public function authorized_leave(){
        $function = $this->function;
        return view('admin.employee.extra_partial_page.authorized_leave',compact('function'));
    }
    public function lien(){
        return view('admin.employee.extra_partial_page.lien');
    }
}
