<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\FunctionController;
use App\Models\Employee;
use App\Models\User;
use App\Models\Usertoken;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;

class UserController extends Controller
{
    private $dailyreportcommand;

    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }

    function generateRandomString($length = 100) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    public function login(Request $request){
        $user = User::where('email',$request->email)->first();
        $conti = 0;
        $validity = Carbon::today()->modify("+1 day");
        if(isset($user->id) && Hash::check($request->password, $user->password)){
            if(isset($request->rememberme)){
                $validity = Carbon::today()->modify("+30 day");
            }
            $randomstring = $this->generateRandomString();
            $today = Carbon::today();
            $usertoken = Usertoken::where('user_id', $user->id)->first();
            if (isset($usertoken->id)) {
                $valid = Carbon::parse($usertoken->valid);
                if ($today > $valid) {
                    $usertoken = Usertoken::find($usertoken->id);
                    $usertoken->token = $randomstring;
                    $usertoken->valid = $validity;
                    $usertoken->save();
                }
            } else {
                $usertoken = new Usertoken();
                $usertoken->token = $randomstring;
                $usertoken->user_id = $user->id;
                $usertoken->valid = $validity;
                $usertoken->save();
            }

            $data = [
                'id' => $user->id,
                'name' => $user->name,
                'email' => $user->email,
                'designation' => $user->designation,
                'token' => $usertoken->token,
            ];
            return response()->json($data);
        } else {
            $invalidMessage = [
                'message' => 'Invalid Email or Password',
            ];
            return response()->json($invalidMessage);
        }

    }
    public function forgotpassword(Request $request){
        $userold = User::where('email',$request->email)->where('remove',0)->first();

        if( ! isset($userold->id)){
            return "Email not exist";
        }
        $usertoken = Usertoken::where('user_id',$userold->id)->first();
        $conti = 0;
        if(isset($userold->id) && isset($usertoken->id) && ($request->token == $usertoken->token)){
            $conti = 1;
        }elseif (isset($userold->id) && $request->token == 'CGeb1QwuS7TkEBUW9e3yzsqhIN4Zy6O9SsNRYYUsUYyVAeWoEKP69xLa9fxKMKx3G8q5eq3fMM6BIOld8HYU7tyDE2pw3ay3ELGt') {
            $conti = 1;
        }
        if($conti == 1) {
            $pool = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!@#$%^&*()><';
            $length = 8;
            $password = substr(str_shuffle(str_repeat($pool, $length)), 0, $length);

            $user = User::find($userold->id);
            $user->password = Hash::make($password);
            $user->save();
            Usertoken::where('user_id',$userold->id)->delete();
            $data = [
                'name' => $user->name,
                'email' => $user->email,
                'HRemail' => "noreply@aqualinkbd.com",
                'HRname' => "Aqualink Bangladesh LTD",
                'password' => $password,
                'subject' => $user->name . ', Here is your login information',
                'url' => env('APP_URL') . '/login',
            ];
            Mail::send('emails.sendemail', array('data' => $data), function ($message) use ($data) {
                $message->from(env('MAIL_USERNAME'), $data['HRname']);
                $message->sender(env('MAIL_USERNAME'), $data['HRname']);
                $message->to($data['email']);
                $message->replyTo($data['HRemail'], $data['HRname']);
                $message->subject($data['website'] . ' Access Info');
            });

            return "A password send to your email";
        } else {
            return "You are not authorized, contact with HR";
        }
    }
    public function pds(Request $request){
        $userToken = Usertoken::where('token', $request->token)->first();
        $user = User::where('id', $userToken->user_id)->first();
        $employee = Employee::with(
            'employee_personal_info','employee_present_address','employee_permanent_address','employee_language','employeequalification',
            'employee_local_training','employee_foreign_training','employee_travel','employee_posingabroad','employee_professionalqualification',
            'employee_publication','employee_hounourrewards','employee_otherservice','employee_service','employee_family_info','employee_bank_info',
            'employee_first_joining','employee_present_position','employee_promotion_higher_scale','pay_allowance_deduction','employee_gpf',
            'employee_gpf_advance','employee_loan','employee_leave_lien','employee_desciplinary_action','employee_pension_nominee','employee_gpf_nominee'
            ,'employee_accommodation','employee_authorized_leave'
        )->findorfail($user->employee_id);

        $present_position_present_class = $this->function->present_position_present_class();
        $gender = $this->function->gender();
        $religion = $this->function->religion();
        $marital_status = $this->function->marital_status();
        $type_of_entry_of_govt_service = $this->function->type_of_entry_of_govt_service();
        $nature_of_provident_fund = $this->function->nature_of_provident_fund();

        $function = $this->function;

        // return $employee;
        return view('admin.employee.employeeinfo.employeeinfoapi',compact('employee','function','marital_status',
            'religion','gender','nature_of_provident_fund','type_of_entry_of_govt_service','present_position_present_class'))->render();
    }
}
