<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\FunctionController;
use App\Models\LeaveApplication;
use App\Models\LeaveStatus;
use App\Models\LeaveType;
use App\Models\User;
use App\Models\Usertoken;
use App\Models\Employee;
use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Hash;
class LeaveApiController extends Controller
{
    public function __construct(FunctionController $functionController)
    {
        $this->function = $functionController;
    }

    public function leave_lists(Request $request){
       // Log::info($request->all());
        $userToken = Usertoken::where('token', $request->token)->first();
        $user = User::where('id', $userToken->user_id)->first();

        // $leave_type_lists = LeaveStatus::where('employee_id',$user->employee_id)->get();
        // Log::info($leave_type_lists[0]->used);
        $userID = $user->employee_id;
       // Log::info($userID);

       $leave_type_lists = LeaveType::with('myleavestatusApi')->get();
    //    $leave_type_lists = LeaveStatus::with('LeaveType')->get()->where('employee_id', $userID);
    //    Log::info($leave_type_lists[0]);
       //User::with('Driver')->get()->where('name', 'AgroTrace');

        // $leave_type_lists = LeaveType::with(['myleavestatus' => function($q) use ($userID){
        //     $q->select()->where('employee_id', $userID);
        // }])->get();

        // $menucatagories =Menucategory::with(array('childrenRecursive'=>function($query) use ($id){
        //     $query->select()->where('restaurant_id',$id);
        //    }))
        //    ->where('restaurant_id',$id)->where('parent_id','0')->get();

        //    $campaign = Campaign::find($campaign_id);
        //    $buyers = $campaign->buyers()->with('notes')->with(['emails' => function($q) use ($campaign_id){
        //        $q->where('campaign_id', $campaign_id);
        //    }])->get();

        return view('appLeaveTypeList' ,['leave_type_lists' => $leave_type_lists])->render();

    }

    public function getLeaveType(){
        $leave_types = LeaveType::all();
        return $leave_types;
    }

    public function applyLeave(Request $request){
//     Log::info($request->hasfile('supporting_document'));
   Log::info($request->all());

    //   $userToken = Usertoken::where('token', $request->token)->first();
    //   $user = User::find($userToken->user_id);
    //   Log::info($user->name);

        $time1 = strtotime($request->date1);
        $start_date = date('Y-m-d H:i:s',$time1);

        $time2 = strtotime($request->date2);
        $end_date = date('Y-m-d H:i:s',$time2);


        $days = date_diff(date_create($request->date1), date_create($request->date2))->d+1;
        $day_status = json_decode($request->day_type, true);
        if($day_status['id'] == 2){
            $days = $days/2;
        }

    // Log::info($days);
        $userToken = Usertoken::where('token', $request->token)->first();
        $user = User::find($userToken->user_id);
        //Log::info($user->employee_id);


        $total_leaves = LeaveApplication::where('employee_id', $user->employee_id)
            ->where('approval_status', '=', 1)
            ->whereRaw('DATE(created_at) = YEAR(CURDATE())')
            ->sum('days');

        $leave_type = json_decode($request->leave_type, true);

        if($leave_type['exceed_maximum_limit'] == 0 && ($leave_type['balance'] - $total_leaves) < $days){
            return  'You do not have sufficient balance for this leave!';
        }
        //  //   Log::info($leave_type['id']);
        //Log::info( null !== $request->file('supporting_document') );
        //Image 1
        if($request->hasFile('supporting_document1')){

            request()->validate([

                'supporting_document1.*' => 'required|mimes:jpeg,png,jpg,pdf,docx,doc|max:3000',

            ]);
          //  Log::info($request->file('supporting_document'));


          //  foreach ($request->file('supporting_document') as $supporting_document){
              $supporting_document1 = $request->file('supporting_document1');
                $fileName1 = $user->id.'_'.$user->name.'_'.time().mt_rand(100,999).'.'.$supporting_document1->getClientOriginalExtension();

                $supporting_document1->move(public_path('upload/leave_documents'), $fileName1);
              //  $fileNames = $fileNames.$fileName.',';
          //  }
           // Log::info($fileName);
        }

        //Image 2
        if($request->hasFile('supporting_document2')){

            request()->validate([

                'supporting_document2.*' => 'required|mimes:jpeg,png,jpg,pdf,docx,doc|max:3000',

            ]);
          //  Log::info($request->file('supporting_document'));


          //  foreach ($request->file('supporting_document') as $supporting_document){
              $supporting_document2 = $request->file('supporting_document2');
                $fileName2 = $user->id.'_'.$user->name.'_'.time().mt_rand(100,999).'.'.$supporting_document2->getClientOriginalExtension();

                $supporting_document2->move(public_path('upload/leave_documents'), $fileName2);
              //  $fileNames = $fileNames.$fileName.',';
          //  }
           // Log::info($fileName);
        }

        //Image 3
        if($request->hasFile('supporting_document3')){

            request()->validate([

                'supporting_document3.*' => 'required|mimes:jpeg,png,jpg,pdf,docx,doc|max:3000',

            ]);
          //  Log::info($request->file('supporting_document'));


          //  foreach ($request->file('supporting_document') as $supporting_document){
              $supporting_document3 = $request->file('supporting_document3');
                $fileName3 = $user->id.'_'.$user->name.'_'.time().mt_rand(100,999).'.'.$supporting_document3->getClientOriginalExtension();

                $supporting_document3->move(public_path('upload/leave_documents'), $fileName3);
              //  $fileNames = $fileNames.$fileName.',';
          //  }
           // Log::info($fileName);
        }

        $leave_request = new LeaveApplication;
        $leave_request->employee_id = $user->employee_id;
        $leave_request->leave_id = $leave_type['id'];
        $leave_request->day_status = $day_status['id'];
        $leave_request->begin_date = $start_date;
        $leave_request->end_date = $end_date;
        $leave_request->days = $days;

        //file upload
        if(isset($fileName1) && !isset($fileName2) && !isset($fileName3)){
            $leave_request->attachment = 'upload/leave_documents/'.$fileName1;
        }
        else if(!isset($fileName1) && isset($fileName2) && !isset($fileName3)){
            $leave_request->attachment = 'upload/leave_documents/'.$fileName2;
        }
        else if(!isset($fileName1) && !isset($fileName2) && isset($fileName3)){
            $leave_request->attachment = 'upload/leave_documents/'.$fileName3;
        }
        else if(isset($fileName1) && isset($fileName2) && !isset($fileName3)){
            $leave_request->attachment = 'upload/leave_documents/'.$fileName1.','.'upload/leave_documents/'.$fileName2;
        }
        else if(!isset($fileName1) && isset($fileName2) && isset($fileName3)){
            $leave_request->attachment = 'upload/leave_documents/'.$fileName2.','.'upload/leave_documents/'.$fileName3;
        }
        else if(isset($fileName1) && !isset($fileName2) && isset($fileName3)){
            $leave_request->attachment = 'upload/leave_documents/'.$fileName1.','.'upload/leave_documents/'.$fileName3;
        }
        else if(isset($fileName1) && isset($fileName2) && isset($fileName3)){

            $leave_request->attachment = 'upload/leave_documents/'.$fileName1.','.'upload/leave_documents/'.$fileName2.','.'upload/leave_documents/'.$fileName3;
        }

        $leave_request->additional_info = isset($request->additional_info) ? $request->additional_info : "None";
        $leave_request->save();

            return "Success";

            

    }

    public function editLeave(Request $request){
    //    Log::info($request->all());

        $time1 = strtotime($request->date1);
        $start_date = date('Y-m-d H:i:s',$time1);

        $time2 = strtotime($request->date2);
        $end_date = date('Y-m-d H:i:s',$time2);


        $days = date_diff(date_create($request->date1), date_create($request->date2))->d+1;
        $day_status = json_decode($request->day_type, true);
        if($day_status['id'] == 2){
            $days = $days/2;
        }

       // Log::info($days);
        $userToken = Usertoken::where('token', $request->token)->first();
        $user = User::find($userToken->user_id);
        //Log::info($user->employee_id);


        $total_leaves = LeaveApplication::where('employee_id', $user->employee_id)
            ->where('approval_status', '=', 1)
            ->whereRaw('DATE(created_at) = YEAR(CURDATE())')
            ->sum('days');

         $leave_type = json_decode($request->leave_type, true);

        if($leave_type['exceed_maximum_limit'] == 0 && ($leave_type['balance'] - $total_leaves) < $days){
            return  'You do not have sufficient balance for this leave!';
        }

      //Image 1
      if($request->hasFile('supporting_document1')){

        request()->validate([

            'supporting_document1.*' => 'required|mimes:jpeg,png,jpg,pdf,docx,doc|max:3000',

        ]);
      //  Log::info($request->file('supporting_document'));


      //  foreach ($request->file('supporting_document') as $supporting_document){
          $supporting_document1 = $request->file('supporting_document1');
            $fileName1 = $user->id.'_'.$user->name.'_'.time().mt_rand(100,999).'.'.$supporting_document1->getClientOriginalExtension();

            $supporting_document1->move(public_path('upload/leave_documents'), $fileName1);
          //  $fileNames = $fileNames.$fileName.',';
      //  }
       // Log::info($fileName);
    }

    //Image 2
    if($request->hasFile('supporting_document2')){

        request()->validate([

            'supporting_document2.*' => 'required|mimes:jpeg,png,jpg,pdf,docx,doc|max:3000',

        ]);
      //  Log::info($request->file('supporting_document'));


      //  foreach ($request->file('supporting_document') as $supporting_document){
          $supporting_document2 = $request->file('supporting_document2');
            $fileName2 = $user->id.'_'.$user->name.'_'.time().mt_rand(100,999).'.'.$supporting_document2->getClientOriginalExtension();

            $supporting_document2->move(public_path('upload/leave_documents'), $fileName2);
          //  $fileNames = $fileNames.$fileName.',';
      //  }
       // Log::info($fileName);
    }

    //Image 3
    if($request->hasFile('supporting_document3')){

        request()->validate([

            'supporting_document3.*' => 'required|mimes:jpeg,png,jpg,pdf,docx,doc|max:3000',

        ]);
      //  Log::info($request->file('supporting_document'));


      //  foreach ($request->file('supporting_document') as $supporting_document){
          $supporting_document3 = $request->file('supporting_document3');
            $fileName3 = $user->id.'_'.$user->name.'_'.time().mt_rand(100,999).'.'.$supporting_document3->getClientOriginalExtension();

            $supporting_document3->move(public_path('upload/leave_documents'), $fileName3);
          //  $fileNames = $fileNames.$fileName.',';
      //  }
       // Log::info($fileName);
    }

        $leave_request = LeaveApplication::find($request->application_id);
        if(isset($leave_request->id)){

            $leave_request->employee_id = $user->employee_id;
            $leave_request->leave_id = $leave_type['id'];
            $leave_request->day_status = $day_status['id'];
            $leave_request->begin_date = $start_date;
            $leave_request->end_date = $end_date;
            $leave_request->days = $days;
            
               //file upload
            if(isset($fileName1) && !isset($fileName2) && !isset($fileName3)){
                $leave_request->attachment = 'upload/leave_documents/'.$fileName1;
            }
            else if(!isset($fileName1) && isset($fileName2) && !isset($fileName3)){
                $leave_request->attachment = 'upload/leave_documents/'.$fileName2;
            }
            else if(!isset($fileName1) && !isset($fileName2) && isset($fileName3)){
                $leave_request->attachment = 'upload/leave_documents/'.$fileName3;
            }
            else if(isset($fileName1) && isset($fileName2) && !isset($fileName3)){
                $leave_request->attachment = 'upload/leave_documents/'.$fileName1.','.'upload/leave_documents/'.$fileName2;
            }
            else if(!isset($fileName1) && isset($fileName2) && isset($fileName3)){
                $leave_request->attachment = 'upload/leave_documents/'.$fileName2.','.'upload/leave_documents/'.$fileName3;
            }
            else if(isset($fileName1) && !isset($fileName2) && isset($fileName3)){
                $leave_request->attachment = 'upload/leave_documents/'.$fileName1.','.'upload/leave_documents/'.$fileName3;
            }
            else if(isset($fileName1) && isset($fileName2) && isset($fileName3)){

                $leave_request->attachment = 'upload/leave_documents/'.$fileName1.','.'upload/leave_documents/'.$fileName2.','.'upload/leave_documents/'.$fileName3;
            }
            $leave_request->additional_info = isset($request->additional_info) ? $request->additional_info : "None";
            $leave_request->save();

                return "Success";
        }else{
            return "Unsuccessful";
        }

    }

    public function pending_leave(Request $request){
       // Log::info($request);
       $userToken = Usertoken::where('token', $request->token)->first();
       $user = User::find($userToken->user_id);

        $pending_leave = LeaveApplication::
                            where('employee_id', $user->employee_id)
                            ->where('approval_status', 0)->get();

        return $pending_leave;
    }

    public function acc_rej_leave(Request $request){
        $userToken = Usertoken::where('token', $request->token)->first();
        $user = User::find($userToken->user_id);

        $acc_rej_leave = LeaveApplication::
                            where('employee_id', $user->employee_id)
                            ->where('approval_status','!=', 0)->get();

        return $acc_rej_leave;

       // return $pending_leave;
    }

    public function deleteLeave(Request $request){
       // Log::info($request->all());
       $application = LeaveApplication::find($request->id);

        if(isset($application->id) && ($application->approval_status == 0)){
            $application->delete();        //Log::info($application);
    }
    $userToken = Usertoken::where('token', $request->token)->first();
       $user = User::find($userToken->user_id);

        $pending_leave = LeaveApplication::
                            where('employee_id', $user->employee_id)
                            ->where('approval_status', 0)->get();

        return $pending_leave;
   // return "Success";
    }

   public function getLeaveBalance(Request $request){
      // Log::info($request);
      $userToken = Usertoken::where('token', $request->token)->first();
      $user = User::find($userToken->user_id);
      $leave_balance = LeaveStatus::where('leave_type_id', $request->leave_type_id)
                                    ->where('employee_id', $user->employee_id)
                                    ->get();
       // Log::info($leave_balance);
       return $leave_balance;
   }

   public function getTotalLeave(Request $request){
    $userToken = Usertoken::where('token', $request->token)->first();
    $user = User::find($userToken->user_id);
    $total_leave = LeaveStatus::where('employee_id', $user->employee_id)->get();
     // Log::info($leave_balance);
     return $total_leave;
   }

   public function getDesignation(Request $request){
    $userToken = Usertoken::where('token', $request->token)->first();
    $user = User::find($userToken->user_id);
    $employee_info = Employee::where('id', $user->employee_id)->get();
  //  Log::info($employee_info[0]->rank);
    if(isset($employee_info[0]->rank)){
        return $employee_info[0]->rank;
    }
        return 'officer';
   }

   public function forgetPassword(Request $request){
       if(isset($request->email)){
        $user = User::where('email', $request->email)->first();
        if(isset($user->id)){
            $employee_info = Employee::where('id', $user->employee_id)->first();

            $random = mt_rand(1000, 9999);
            $pass = $user->employee_id.$random;

         //   Log::info($user->password);

            $user->password = Hash::make($pass);
            $user->save();
           // Log::info($user->password);
            $number= $employee_info->sms_number;
            $text= "Land Port Authority PIMS: Your password has been changed to : ".$pass;
            $this->function->sendsms($number,$text);
        }
       }
   }

}
