<?php

namespace App\Actions\Fortify;

use App\Http\Controllers\LeaveManagementController;
use App\Models\Employee;
use App\Models\LeaveType;
use App\Models\User;
use Aqualink\District\Models\Quota;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Laravel\Fortify\Contracts\CreatesNewUsers;

class CreateNewUser implements CreatesNewUsers
{
    use PasswordValidationRules;
    public function __construct(LeaveManagementController $leaveManagementController)
    {
        $this->leavemanagement = $leaveManagementController;
    }
    /**
     * Validate and create a newly registered user.
     *
     * @param  array  $input
     * @return \App\Models\User
     */
    public function create(array $input)
    {
        Validator::make($input, [
            'name_bn' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => $this->passwordRules(),
            'rank' => ['required'],
            'dob' => ['required'],
            'type_of_entry' => ['required'],
            'quota' => ['required'],
            'nid' => ['required', 'unique:employees', 'numeric'],
        ])->validate();
        $employee = new Employee();
        $employee ->nid = $input['nid'];
        $employee->name = $input['name_bn'];
        $employee->rank = (int)$input['rank'];
        $employee->quota = (int)$input['quota'];
        $employee->dob = Carbon::parse($input['dob'])->format("Y-m-d");
        $quota=Quota::find((int)$input['quota']);
        if(isset($quota->id)){
            $employee->prl_date = Carbon::parse($input['dob'])->modify('+'.$quota->max_age.' year');
        }
        $employee->toegs = (int)$input['type_of_entry'];
        if(isset($input['sms_number'])){$employee->sms_number = $input['sms_number'];}
        $employee->save();
        $leavetypes = LeaveType::all();
        foreach ($leavetypes as $leave) {
            $this->leavemanagement->leavestatusupdate($employee->id, $leave->id, 0);
        }

        return User::create([
            'name' => $input['name_bn'],
            'email' => $input['email'],
            'password' => Hash::make($input['password']),
            'employee_id' => $employee->id,
        ]);
    }
}
